/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2Node;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.kafka.common.TopicIdPartition;

public class K2MetadataUtil {
    private static final XXHash64 HASHER = XXHashFactory.fastestInstance().hash64();

    public static int hrwHashPartitionLeader(TopicIdPartition partition, List<Integer> nodes) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("candidate node list must not be empty");
        }
        return (Integer)((AbstractMap.SimpleEntry)nodes.stream().map(id -> new AbstractMap.SimpleEntry<Integer, Long>((Integer)id, K2MetadataUtil.hashTopicToNode(partition, id))).max(Map.Entry.comparingByValue()).get()).getKey();
    }

    public static List<K2Node> getPotentialControllerNodes(List<K2Node> eligibleK2Nodes) {
        return eligibleK2Nodes.stream().collect(Collectors.groupingBy(K2Node::zone, Collectors.minBy(Comparator.comparing(K2Node::id)))).values().stream().flatMap(Optional::stream).toList();
    }

    private static long hashTopicToNode(TopicIdPartition partition, int nodeId) {
        ByteBuffer buf = ByteBuffer.allocate(24).putLong(partition.topicId().getMostSignificantBits()).putLong(partition.topicId().getLeastSignificantBits()).putInt(partition.partition()).putInt(nodeId);
        buf.flip();
        return HASHER.hash(buf, 123L);
    }
}

