/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.common.RequestFeatureFilter;

public class K2RequestDeterminationBasedOnContextOnly
implements RequestFeatureFilter {
    public boolean appliesTo(AbstractRequest request, RequestContext context, Optional<Supplier<Set<String>>> sessionTopicNames) {
        return K2RequestDeterminationBasedOnContextOnly.isMultitenantPrincipal(context);
    }

    private static boolean isMultitenantPrincipal(RequestContext context) {
        return K2RequestDeterminationBasedOnContextOnly.multiTenantPrincipalFor(context).isPresent();
    }

    private static Optional<MultiTenantPrincipal> multiTenantPrincipalFor(RequestContext context) {
        KafkaPrincipal kafkaPrincipal = context.principal();
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            return Optional.of((MultiTenantPrincipal)kafkaPrincipal);
        }
        return Optional.empty();
    }
}

