/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.KsqlSecurityExtension;
import io.confluent.ksql.security.KsqlUserContextProvider;
import io.confluent.ksql.security.KsqlUserContextProviderImpl;
import io.confluent.ksql.security.authorizer.KsqlResourceActionsMapping;
import io.confluent.ksql.security.authorizer.KsqlRestAuthorizer;
import io.confluent.ksql.security.utils.KsqlSecurityUtils;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.security.auth.client.RestAuthorizer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlConfluentSecurityExtension
implements KsqlSecurityExtension {
    private static final Logger log = LoggerFactory.getLogger(KsqlConfluentSecurityExtension.class);
    private static final String SASL_PREFIX = "SASL_";
    private RestAuthorizer restAuthorizer;
    private KsqlAuthorizationProvider authorizationProvider;
    private KsqlUserContextProvider userContextProvider;
    private final Supplier<RestAuthorizer> restAuthBuilder;
    private final Function<KsqlConfig, String> kafkaClusterIdSupplier;

    public KsqlConfluentSecurityExtension() {
        this(RestAuthorizer::new, KsqlSecurityUtils::getKafkaClusterId);
    }

    @VisibleForTesting
    KsqlConfluentSecurityExtension(Supplier<RestAuthorizer> restAuthBuilder, Function<KsqlConfig, String> kafkaClusterIdSupplier) {
        this.restAuthBuilder = Objects.requireNonNull(restAuthBuilder, "restAuthBuilder");
        this.kafkaClusterIdSupplier = Objects.requireNonNull(kafkaClusterIdSupplier, "kafkaClusterIdSupplier");
    }

    public void initialize(KsqlConfig ksqlConfig) {
        this.checkInvalidConfiguration(ksqlConfig);
        this.restAuthorizer = this.restAuthBuilder.get();
        this.restAuthorizer.configure(ksqlConfig.originals());
        this.authorizationProvider = new KsqlRestAuthorizer(this.restAuthorizer, new KsqlResourceActionsMapping(ksqlConfig.getString("ksql.service.id"), this.kafkaClusterIdSupplier.apply(ksqlConfig)));
        this.userContextProvider = new KsqlUserContextProviderImpl(ksqlConfig);
        log.info("KSQL security extension registered.");
    }

    private void checkInvalidConfiguration(KsqlConfig ksqlConfig) {
        String protocolConfig = ksqlConfig.getKsqlAdminClientConfigProps().getOrDefault("security.protocol", "");
        if (protocolConfig.isEmpty()) {
            this.throwInitializationException(String.format("'%s' is empty. Only SASL_PLAINTEXT and SASL_SSL are allowed.", "security.protocol"));
        }
        try {
            SecurityProtocol securityProtocol = SecurityProtocol.forName((String)protocolConfig);
            if (securityProtocol != SecurityProtocol.SASL_PLAINTEXT && securityProtocol != SecurityProtocol.SASL_SSL) {
                this.throwInitializationException(String.format("Unsupported '%s' value (%s). Only SASL_PLAINTEXT and SASL_SSL are allowed.", "security.protocol", protocolConfig));
            }
        }
        catch (IllegalArgumentException e) {
            this.throwInitializationException(String.format("Unknown '%s' value (%s). Only SASL_PLAINTEXT and SASL_SSL are allowed.", "security.protocol", protocolConfig));
        }
    }

    private void throwInitializationException(String cause) {
        throw new KsqlException(String.format("Failed to initialize Confluent RBAC: %s", cause));
    }

    public Optional<KsqlAuthorizationProvider> getAuthorizationProvider() {
        return Optional.of(this.authorizationProvider);
    }

    public Optional<KsqlUserContextProvider> getUserContextProvider() {
        return Optional.of(this.userContextProvider);
    }

    public void close() {
        if (this.restAuthorizer != null) {
            try {
                this.restAuthorizer.close();
            }
            catch (Exception e) {
                throw new KsqlException("Failed to close the security rest authorizer", (Throwable)e);
            }
            this.restAuthorizer = null;
        }
        log.info("KSQL security extension deregistered.");
    }
}

