/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.authorizer;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.security.authorizer.ResourceActionsMapping;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.util.Map;

public class KsqlResourceActionsMapping
implements ResourceActionsMapping {
    private static final String KSQL_CLUSTER_TYPE = "ksql-cluster";
    private static final String KSQL_RESOURCE_NAME = "ksql-cluster";
    private static final ResourceType KSQL_RESOURCE_TYPE = new ResourceType("KsqlCluster");
    private static final Operation CONTRIBUTE = new Operation("Contribute");
    private static final Operation TERMINATE = new Operation("Terminate");
    private static final Map<String, Operation> OPERATION_MAP = new ImmutableMap.Builder().put((Object)"/ksql/terminate", (Object)TERMINATE).build();
    private final Scope scope;

    public KsqlResourceActionsMapping(String ksqlClusterId, String kafkaClusterId) {
        this.scope = new Scope.Builder(new String[0]).withCluster("ksql-cluster", ksqlClusterId).withKafkaCluster(kafkaClusterId).build();
    }

    @Override
    public Action get(String path) {
        Operation requiredOperation = OPERATION_MAP.getOrDefault(path.toLowerCase(), CONTRIBUTE);
        return new Action(this.scope, KSQL_RESOURCE_TYPE, "ksql-cluster", requiredOperation);
    }
}

