/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.authorizer;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.ksql.rest.server.resources.ServerInfoResource;
import io.confluent.ksql.security.KsqlAuthorizationProvider;
import io.confluent.ksql.security.authorizer.ResourceActionsMapping;
import io.confluent.ksql.security.utils.KsqlSecurityUtils;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.auth.client.provider.HttpBearerCredentialProvider;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Path;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlRestAuthorizer
implements KsqlAuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(KsqlRestAuthorizer.class);
    private final RestAuthorizer restAuthorizer;
    private final ResourceActionsMapping resourceActionsMapping;

    public KsqlRestAuthorizer(RestAuthorizer restAuthorizer, ResourceActionsMapping resourceActionsMapping) {
        this.restAuthorizer = restAuthorizer;
        this.resourceActionsMapping = resourceActionsMapping;
    }

    public void checkEndpointAccess(Principal principal, String method, String path) {
        JwtPrincipal jwtPrincipal = KsqlSecurityUtils.toJwtPrincipal(principal);
        if (this.isServerInfoEndpoint(path)) {
            return;
        }
        Action actionRequired = this.resourceActionsMapping.get(path);
        List authorizeResults = this.restAuthorizer.authorize((HttpCredentialProvider)KsqlRestAuthorizer.toBearerCredentials(jwtPrincipal), KsqlRestAuthorizer.toKafkaUserPrincipal(jwtPrincipal), null, Collections.singletonList(actionRequired));
        if (authorizeResults.size() != 1) {
            throw new IllegalStateException("Authorizer returned unexpected results. Expected 1, got " + authorizeResults.size());
        }
        if (authorizeResults.get(0) != AuthorizeResult.ALLOWED) {
            log.warn("User:{} is Denied operation = {} on endpoint = \"{} {}\"", new Object[]{jwtPrincipal.getName(), actionRequired.operation(), method, path});
            throw new AuthorizationException("You are forbidden from using this cluster.");
        }
    }

    private boolean isServerInfoEndpoint(String path) {
        return path.equals(ServerInfoResource.class.getAnnotation(Path.class).value());
    }

    private static HttpBearerCredentialProvider toBearerCredentials(JwtPrincipal principal) {
        return new HttpBearerCredentialProvider(principal.getJwt());
    }

    private static KafkaPrincipal toKafkaUserPrincipal(JwtPrincipal principal) {
        return new KafkaPrincipal("User", principal.getName());
    }
}

