/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security;

import io.confluent.ksql.api.auth.AuthenticationPlugin;
import io.confluent.ksql.util.VertxCompletableFuture;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.WorkerExecutor;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

public abstract class VertxAuthenticationPlugin
implements AuthenticationPlugin {
    protected Authenticator authenticator;

    public CompletableFuture<Principal> handleAuth(RoutingContext routingContext, WorkerExecutor workerExecutor) {
        VertxCompletableFuture cf = new VertxCompletableFuture();
        workerExecutor.executeBlocking(promise -> this.handleAuthBlocking(routingContext, (Promise<Principal>)promise), (Handler)cf);
        return cf;
    }

    public abstract void configure(Map<String, ?> var1);

    protected void configure(final String realm, final Authenticator authenticator, final LoginService loginService) {
        this.authenticator = authenticator;
        loginService.setIdentityService((IdentityService)new DefaultIdentityService());
        if (loginService instanceof AbstractLifeCycle) {
            try {
                ((AbstractLifeCycle)loginService).start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        authenticator.setConfiguration(new Authenticator.AuthConfiguration(){

            public String getAuthMethod() {
                return authenticator.getAuthMethod();
            }

            public String getRealmName() {
                return realm;
            }

            public String getInitParameter(String param) {
                throw new UnsupportedOperationException();
            }

            public Set<String> getInitParameterNames() {
                throw new UnsupportedOperationException();
            }

            public LoginService getLoginService() {
                return loginService;
            }

            public IdentityService getIdentityService() {
                return loginService.getIdentityService();
            }

            public boolean isSessionRenewedOnAuthentication() {
                return false;
            }
        });
    }

    protected abstract boolean validateUser(UserIdentity var1);

    private void handleAuthBlocking(RoutingContext routingContext, Promise<Principal> promise) {
        if (this.authenticator == null) {
            throw new IllegalStateException("Not configured");
        }
        try {
            WrappedResponse response = VertxAuthenticationPlugin.toServletResponse(routingContext);
            Authentication authentication = this.authenticator.validateRequest(VertxAuthenticationPlugin.toServletRequest(routingContext), (ServletResponse)response, true);
            if (authentication instanceof Authentication.User) {
                Authentication.User userAuthentication = (Authentication.User)authentication;
                UserIdentity userIdentity = userAuthentication.getUserIdentity();
                if (!this.validateUser(userIdentity)) {
                    promise.complete();
                } else {
                    promise.complete((Object)userIdentity.getUserPrincipal());
                }
            } else {
                promise.complete();
            }
        }
        catch (ServerAuthException e) {
            promise.fail((Throwable)e);
        }
    }

    private static ServletRequest toServletRequest(RoutingContext routingContext) {
        return new WrappedRequest(routingContext);
    }

    private static WrappedResponse toServletResponse(RoutingContext routingContext) {
        return new WrappedResponse(routingContext);
    }

    private static class WrappedResponse
    implements HttpServletResponse {
        private final RoutingContext routingContext;

        public WrappedResponse(RoutingContext routingContext) {
            this.routingContext = routingContext;
        }

        public String getCharacterEncoding() {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public PrintWriter getWriter() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void setCharacterEncoding(String s) {
            throw new UnsupportedOperationException();
        }

        public void setContentLength(int i) {
            throw new UnsupportedOperationException();
        }

        public void setContentLengthLong(long l) {
            throw new UnsupportedOperationException();
        }

        public void setContentType(String s) {
            throw new UnsupportedOperationException();
        }

        public void setBufferSize(int i) {
            throw new UnsupportedOperationException();
        }

        public int getBufferSize() {
            throw new UnsupportedOperationException();
        }

        public void flushBuffer() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void resetBuffer() {
            throw new UnsupportedOperationException();
        }

        public boolean isCommitted() {
            throw new UnsupportedOperationException();
        }

        public void reset() {
            throw new UnsupportedOperationException();
        }

        public void setLocale(Locale locale) {
            throw new UnsupportedOperationException();
        }

        public Locale getLocale() {
            throw new UnsupportedOperationException();
        }

        public void addCookie(Cookie cookie) {
            throw new UnsupportedOperationException();
        }

        public boolean containsHeader(String s) {
            throw new UnsupportedOperationException();
        }

        public String encodeURL(String s) {
            throw new UnsupportedOperationException();
        }

        public String encodeRedirectURL(String s) {
            throw new UnsupportedOperationException();
        }

        public String encodeUrl(String s) {
            throw new UnsupportedOperationException();
        }

        public String encodeRedirectUrl(String s) {
            throw new UnsupportedOperationException();
        }

        public void sendError(int i, String s) throws IOException {
        }

        public void sendError(int statusCode) throws IOException {
        }

        public void sendRedirect(String s) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void setDateHeader(String s, long l) {
            throw new UnsupportedOperationException();
        }

        public void addDateHeader(String s, long l) {
            throw new UnsupportedOperationException();
        }

        public void setHeader(String headerName, String headerValue) {
            this.routingContext.response().putHeader(headerName, headerValue);
        }

        public void addHeader(String s, String s1) {
            throw new UnsupportedOperationException();
        }

        public void setIntHeader(String s, int i) {
            throw new UnsupportedOperationException();
        }

        public void addIntHeader(String s, int i) {
            throw new UnsupportedOperationException();
        }

        public void setStatus(int i) {
            throw new UnsupportedOperationException();
        }

        public void setStatus(int i, String s) {
            throw new UnsupportedOperationException();
        }

        public int getStatus() {
            throw new UnsupportedOperationException();
        }

        public String getHeader(String headerName) {
            return this.routingContext.response().headers().get(headerName);
        }

        public Collection<String> getHeaders(String s) {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getHeaderNames() {
            throw new UnsupportedOperationException();
        }
    }

    private static class WrappedRequest
    implements HttpServletRequest {
        private final RoutingContext routingContext;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public WrappedRequest(RoutingContext routingContext) {
            this.routingContext = routingContext;
        }

        public synchronized Object getAttribute(String attributeName) {
            return this.attributes.get(attributeName);
        }

        public Enumeration<String> getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public String getCharacterEncoding() {
            throw new UnsupportedOperationException();
        }

        public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
            throw new UnsupportedOperationException();
        }

        public int getContentLength() {
            throw new UnsupportedOperationException();
        }

        public long getContentLengthLong() {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        public ServletInputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getParameter(String s) {
            return this.routingContext.request().getParam(s);
        }

        public Enumeration<String> getParameterNames() {
            throw new UnsupportedOperationException();
        }

        public String[] getParameterValues(String s) {
            throw new UnsupportedOperationException();
        }

        public Map<String, String[]> getParameterMap() {
            throw new UnsupportedOperationException();
        }

        public String getProtocol() {
            throw new UnsupportedOperationException();
        }

        public String getScheme() {
            throw new UnsupportedOperationException();
        }

        public String getServerName() {
            throw new UnsupportedOperationException();
        }

        public int getServerPort() {
            throw new UnsupportedOperationException();
        }

        public BufferedReader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getRemoteAddr() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteHost() {
            throw new UnsupportedOperationException();
        }

        public synchronized void setAttribute(String name, Object value) {
            this.attributes.put(name, value);
        }

        public void removeAttribute(String s) {
            throw new UnsupportedOperationException();
        }

        public Locale getLocale() {
            throw new UnsupportedOperationException();
        }

        public Enumeration<Locale> getLocales() {
            throw new UnsupportedOperationException();
        }

        public boolean isSecure() {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getRequestDispatcher(String s) {
            throw new UnsupportedOperationException();
        }

        public String getRealPath(String s) {
            throw new UnsupportedOperationException();
        }

        public int getRemotePort() {
            throw new UnsupportedOperationException();
        }

        public String getLocalName() {
            throw new UnsupportedOperationException();
        }

        public String getLocalAddr() {
            throw new UnsupportedOperationException();
        }

        public int getLocalPort() {
            throw new UnsupportedOperationException();
        }

        public ServletContext getServletContext() {
            throw new UnsupportedOperationException();
        }

        public AsyncContext startAsync() throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public boolean isAsyncStarted() {
            throw new UnsupportedOperationException();
        }

        public boolean isAsyncSupported() {
            throw new UnsupportedOperationException();
        }

        public AsyncContext getAsyncContext() {
            throw new UnsupportedOperationException();
        }

        public DispatcherType getDispatcherType() {
            throw new UnsupportedOperationException();
        }

        public String getAuthType() {
            throw new UnsupportedOperationException();
        }

        public Cookie[] getCookies() {
            Map cookieMap = this.routingContext.request().cookieMap();
            Cookie[] cookies = new Cookie[cookieMap.size()];
            int index = 0;
            for (io.vertx.core.http.Cookie cookie : cookieMap.values()) {
                Cookie cook = new Cookie(cookie.getName(), cookie.getValue());
                cookies[index++] = cook;
            }
            return cookies;
        }

        public long getDateHeader(String s) {
            throw new UnsupportedOperationException();
        }

        public String getHeader(String headerName) {
            return this.routingContext.request().getHeader(headerName);
        }

        public Enumeration<String> getHeaders(String s) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getHeaderNames() {
            throw new UnsupportedOperationException();
        }

        public int getIntHeader(String s) {
            throw new UnsupportedOperationException();
        }

        public String getMethod() {
            throw new UnsupportedOperationException();
        }

        public String getPathInfo() {
            throw new UnsupportedOperationException();
        }

        public String getPathTranslated() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            throw new UnsupportedOperationException();
        }

        public String getQueryString() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteUser() {
            throw new UnsupportedOperationException();
        }

        public boolean isUserInRole(String s) {
            throw new UnsupportedOperationException();
        }

        public Principal getUserPrincipal() {
            throw new UnsupportedOperationException();
        }

        public String getRequestedSessionId() {
            throw new UnsupportedOperationException();
        }

        public String getRequestURI() {
            return this.routingContext.request().uri();
        }

        public StringBuffer getRequestURL() {
            throw new UnsupportedOperationException();
        }

        public String getServletPath() {
            throw new UnsupportedOperationException();
        }

        public HttpSession getSession(boolean b) {
            throw new UnsupportedOperationException();
        }

        public HttpSession getSession() {
            throw new UnsupportedOperationException();
        }

        public String changeSessionId() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdValid() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromCookie() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromURL() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromUrl() {
            throw new UnsupportedOperationException();
        }

        public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }

        public void login(String s, String s1) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public void logout() throws ServletException {
            throw new UnsupportedOperationException();
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }

        public Part getPart(String s) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> clazz) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }
    }
}

