/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.authorizer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.ksql.exception.KsqlSchemaAuthorizationException;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.security.clients.KsqlSchemaRegistryPermissionsClient;
import io.confluent.ksql.security.utils.KsqlSecurityUtils;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.acl.AclOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlSchemaRegistryPermissionsValidator {
    private static final Logger log = LoggerFactory.getLogger(KsqlSchemaRegistryPermissionsValidator.class);
    private final KsqlConfig ksqlConfig;
    private final BiFunction<KsqlConfig, Map<String, String>, KsqlSchemaRegistryPermissionsClient> srPermissionsClientFactory;

    public KsqlSchemaRegistryPermissionsValidator(KsqlConfig ksqlConfig) {
        this(ksqlConfig, KsqlSchemaRegistryPermissionsClient::new);
    }

    @VisibleForTesting
    KsqlSchemaRegistryPermissionsValidator(KsqlConfig ksqlConfig, BiFunction<KsqlConfig, Map<String, String>, KsqlSchemaRegistryPermissionsClient> srPermissionsClientFactory) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.srPermissionsClientFactory = Objects.requireNonNull(srPermissionsClientFactory, "srPermissionsClientFactory");
    }

    public static boolean isSchemaRegistryPermissionsEnabled(KsqlConfig ksqlConfig) {
        return KsqlSchemaRegistryPermissionsValidator.isSchemaRegistryPermissionsEnabled(ksqlConfig, KsqlSchemaRegistryPermissionsClient::new);
    }

    @VisibleForTesting
    static boolean isSchemaRegistryPermissionsEnabled(KsqlConfig ksqlConfig, BiFunction<KsqlConfig, Map<String, String>, KsqlSchemaRegistryPermissionsClient> srPermissionsClientFactory) {
        if (ksqlConfig.getString("ksql.schema.registry.url").trim().isEmpty()) {
            return false;
        }
        log.info("Checking if Schema Registry /permissions is configured");
        KsqlSchemaRegistryPermissionsClient client = srPermissionsClientFactory.apply(ksqlConfig, (Map<String, String>)ImmutableMap.of());
        try {
            client.permissions();
        }
        catch (RestClientException | IOException e) {
            if (e instanceof RestClientException && ((RestClientException)e).getStatus() == 404) {
                log.info("Schema Registry /permissions endpoint not found");
                return false;
            }
            throw new KsqlException("Unable to check /permissions endpoint on SchemaRegistry: " + e.getMessage(), e);
        }
        log.info("Schema Registry /permissions endpoint found");
        return true;
    }

    public void checkSubjectAccess(KsqlSecurityContext securityContext, String subjectName, AclOperation operation) {
        Collection<String> permittedOperations;
        KsqlSchemaRegistryPermissionsClient srClient = this.srPermissionsClientFactory.apply(this.ksqlConfig, this.getHttpHeaders(securityContext));
        try {
            permittedOperations = srClient.permissions(subjectName);
        }
        catch (RestClientException | IOException e) {
            throw new KsqlException("Unable to check /permissions endpoint on SchemaRegistry: " + e.getMessage(), e);
        }
        if (!permittedOperations.contains(StringUtils.capitalize((String)operation.name().toLowerCase()))) {
            log.debug("KsqlSchemaAuthorizationException. Permitted operations ({}) do not contain Operation ({})", permittedOperations, (Object)operation.name().toLowerCase());
            throw new KsqlSchemaAuthorizationException(operation, subjectName);
        }
    }

    private Map<String, String> getHttpHeaders(KsqlSecurityContext securityContext) {
        return securityContext.getUserPrincipal().map(p -> KsqlSecurityUtils.toPrincipalType((Principal)p, JwtPrincipal.class)).map(KsqlSecurityUtils::getSchemaRegistryClientHttpHeaders).orElse((Map)ImmutableMap.of());
    }
}

