/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.authorizer;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.ksql.security.authorizer.AuthorizationDecisionMaker;
import io.confluent.ksql.security.utils.KsqlSecurityUtils;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.auth.client.provider.HttpBearerCredentialProvider;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class MdsRestAuthorizationDecisionMaker
implements AuthorizationDecisionMaker {
    private static final String KSQL_CLUSTER_TYPE = "ksql-cluster";
    private static final ResourceType KSQL_RESOURCE_TYPE = new ResourceType("KsqlCluster");
    private final RestAuthorizer mdsRestAuthorizer;
    private final Function<KsqlConfig, String> kafkaClusterIdSupplier;
    private Scope scope;

    public MdsRestAuthorizationDecisionMaker() {
        this(RestAuthorizer::new, KsqlSecurityUtils::getKafkaClusterId);
    }

    @VisibleForTesting
    MdsRestAuthorizationDecisionMaker(Supplier<RestAuthorizer> restAuthorizerSupplier, Function<KsqlConfig, String> kafkaClusterIdSupplier) {
        this.mdsRestAuthorizer = Objects.requireNonNull(restAuthorizerSupplier, "restAuthorizerSupplier").get();
        this.kafkaClusterIdSupplier = Objects.requireNonNull(kafkaClusterIdSupplier, "kafkaClusterIdSupplier");
    }

    @Override
    public void initialize(KsqlConfig ksqlConfig) {
        this.mdsRestAuthorizer.configure(ksqlConfig.originals());
        String ksqlClusterId = ksqlConfig.getString("ksql.service.id");
        String kafkaClusterId = this.kafkaClusterIdSupplier.apply(ksqlConfig);
        this.scope = new Scope.Builder(new String[0]).withCluster(KSQL_CLUSTER_TYPE, ksqlClusterId).withKafkaCluster(kafkaClusterId).build();
    }

    @Override
    public void close() throws IOException {
        this.mdsRestAuthorizer.close();
    }

    @Override
    public AuthorizeResult checkAuthorization(Principal principal, String resourceType, String resourceName, String operation) {
        JwtPrincipal jwtPrincipal = KsqlSecurityUtils.toPrincipalType(principal, JwtPrincipal.class);
        List authorizeResults = this.mdsRestAuthorizer.authorize((HttpCredentialProvider)this.toBearerCredentials(jwtPrincipal), this.toKafkaUserPrincipal(jwtPrincipal), null, Collections.singletonList(new Action(this.scope, new ResourceType(resourceType), KSQL_CLUSTER_TYPE, new Operation(operation))));
        if (authorizeResults.size() != 1) {
            throw new IllegalStateException("MDS returned unexpected results. Expected 1, got " + authorizeResults.size());
        }
        return (AuthorizeResult)authorizeResults.get(0);
    }

    private HttpBearerCredentialProvider toBearerCredentials(JwtPrincipal principal) {
        return new HttpBearerCredentialProvider(principal.getJwt());
    }

    private KafkaPrincipal toKafkaUserPrincipal(JwtPrincipal principal) {
        return new KafkaPrincipal("User", principal.getName());
    }
}

