/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.security.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.security.permissions.entities.Permissions;
import io.confluent.kafka.schemaregistry.security.permissions.entities.PermittedOperations;
import io.confluent.ksql.security.clients.KsqlSchemaRegistryRestService;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.security.authorizer.ResourceType;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriBuilder;

public class KsqlSchemaRegistryPermissionsClient {
    private static final TypeReference<Permissions> GET_PERMISSIONS_RESPONSE_TYPE = new TypeReference<Permissions>(){};
    private static final ResourceType SUBJECT_RESOURCE_TYPE = new ResourceType("Subject");
    private final KsqlSchemaRegistryRestService srRestService;

    public KsqlSchemaRegistryPermissionsClient(KsqlConfig ksqlConfig, Map<String, String> httpHeaders) {
        this(new KsqlSchemaRegistryRestService(ksqlConfig, httpHeaders));
    }

    @VisibleForTesting
    KsqlSchemaRegistryPermissionsClient(KsqlSchemaRegistryRestService srRestService) {
        this.srRestService = Objects.requireNonNull(srRestService, "srRestService");
    }

    public Collection<String> permissions(String subjectName) throws RestClientException, IOException {
        Map<String, PermittedOperations> operationsBySubject = this.permissions().getOrDefault(SUBJECT_RESOURCE_TYPE, (Map<String, PermittedOperations>)ImmutableMap.of());
        if (operationsBySubject.containsKey(subjectName)) {
            return operationsBySubject.get(subjectName).getPermittedOperations();
        }
        return Collections.emptyList();
    }

    public Map<ResourceType, Map<String, PermittedOperations>> permissions() throws RestClientException, IOException {
        UriBuilder builder = UriBuilder.fromPath((String)"/permissions");
        Permissions permissions = this.srRestService.httpRequest(builder.toString(), "GET", null, GET_PERMISSIONS_RESPONSE_TYPE);
        return permissions.getPermissions();
    }
}

