/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license.validator;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.utils.Utils;

public class LicenseConfig
extends AbstractConfig {
    public static final String PREFIX = "confluent.license.";
    public static final String PRODUCER_PREFIX = "confluent.license.producer.";
    public static final String CONSUMER_PREFIX = "confluent.license.consumer.";
    public static final String ADMIN_PREFIX = "confluent.license.admin.";
    public static final String LICENSE_PROP = "confluent.license";
    private static final String LICENSE_DEFAULT = "";
    private static final String LICENSE_DOC = "License for Confluent plugins.";
    public static final String TOPIC_PROP = "confluent.license.topic";
    public static final String TOPIC_DEFAULT = "_confluent-license";
    private static final String TOPIC_DOC = "Topic used for storing Confluent license";
    public static final String REPLICATION_FACTOR_PROP = "confluent.license.topic.replication.factor";
    private static final short REPLICATION_FACTOR_DEFAULT = 3;
    private static final String REPLICATION_FACTOR_DOC = "Replication factor of the license topic. This is used for creation of the topic if it doesn't exist. Replication factor cannot be altered after the topic is created.";
    public static final String TOPIC_CREATE_TIMEOUT_PROP = "confluent.license.topic.create.timeout.ms";
    public static final int TOPIC_CREATE_TIMEOUT_DEFAULT = 600000;
    public static final String TOPIC_CREATE_TIMEOUT_DOC = "The number of milliseconds to wait for license topic to be created during start up.";
    public static final String RETRY_BACKOFF_MIN_MS_PROP = "confluent.license.retry.backoff.min.ms";
    public static final int RETRY_BACKOFF_MIN_MS_DEFAULT = 1000;
    public static final String RETRY_BACKOFF_MIN_MS_DOC = "Minimum backoff when retrying license topic creation.";
    public static final String RETRY_BACKOFF_MAX_MS_PROP = "confluent.license.retry.backoff.max.ms";
    public static final int RETRY_BACKOFF_MAX_MS_DEFAULT = 100000;
    public static final String RETRY_BACKOFF_MAX_MS_DOC = "Maximum backoff when retrying license topic creation.";
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.license", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "License for Confluent plugins.").define("confluent.license.topic", ConfigDef.Type.STRING, (Object)"_confluent-license", ConfigDef.Importance.LOW, "Topic used for storing Confluent license").define("confluent.license.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Replication factor of the license topic. This is used for creation of the topic if it doesn't exist. Replication factor cannot be altered after the topic is created.").define("confluent.license.topic.create.timeout.ms", ConfigDef.Type.INT, (Object)600000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The number of milliseconds to wait for license topic to be created during start up.").define("confluent.license.retry.backoff.min.ms", ConfigDef.Type.INT, (Object)1000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Minimum backoff when retrying license topic creation.").define("confluent.license.retry.backoff.max.ms", ConfigDef.Type.INT, (Object)100000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Maximum backoff when retrying license topic creation.");
    public final String license;
    public final String topic;
    final Duration topicCreateTimeout;
    final int replicationFactor;
    final Duration retryBackoffMinMs;
    final Duration retryBackoffMaxMs;
    private final String componentId;

    public LicenseConfig(String componentId, Map<?, ?> props) {
        super(CONFIG, props);
        this.componentId = componentId;
        this.license = this.getString(LICENSE_PROP);
        this.topic = this.getString(TOPIC_PROP);
        this.replicationFactor = this.getShort(REPLICATION_FACTOR_PROP).shortValue();
        this.topicCreateTimeout = Duration.ofMillis(this.getInt(TOPIC_CREATE_TIMEOUT_PROP).intValue());
        this.retryBackoffMinMs = Duration.ofMillis(this.getInt(RETRY_BACKOFF_MIN_MS_PROP).intValue());
        this.retryBackoffMaxMs = Duration.ofMillis(this.getInt(RETRY_BACKOFF_MAX_MS_PROP).intValue());
    }

    public Map<String, Object> producerConfigs() {
        return ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.PRODUCER, (String)TOPIC_DEFAULT, (String)this.componentId);
    }

    public Map<String, Object> consumerConfigs() {
        return ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.CONSUMER, (String)TOPIC_DEFAULT, (String)this.componentId);
    }

    public Map<String, Object> topicAndAdminClientConfigs() {
        Map configs = ConfluentConfigs.clientConfigs((AbstractConfig)this, (String)PREFIX, (ConfluentConfigs.ClientType)ConfluentConfigs.ClientType.ADMIN, (String)TOPIC_DEFAULT, (String)this.componentId);
        configs.put("replication.factor", String.valueOf(this.replicationFactor));
        configs.put("min.insync.replicas", String.valueOf(Math.min(this.replicationFactor, 2)));
        return configs;
    }

    public String toString() {
        return String.format("%s: %n\t%s", ((Object)((Object)this)).getClass().getName(), Utils.mkString((Map)this.values(), (String)LICENSE_DEFAULT, (String)LICENSE_DEFAULT, (String)"=", (String)"%n\t"));
    }

    public static void main(String[] args) throws Exception {
        try (PrintStream out = args.length == 0 ? System.out : new PrintStream((OutputStream)new FileOutputStream(args[0]), false, StandardCharsets.UTF_8.name());){
            out.println(CONFIG.toHtmlTable());
            if (out != System.out) {
                out.close();
            }
        }
    }
}

