/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.license;

import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.util.LicenseAddonTypes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.jose4j.jwt.JwtClaims;

class CPForCCLicense
extends License {
    private final Time clock;
    private static final String SKU = "SKU";
    private static final String EXPIRY_ON = "exp";
    private static final String ISSUED_AT = "iat";
    private static final String CP_FOR_CC_LICENSE = "CP for CC License";

    CPForCCLicense(JwtClaims claims, Time clock, String serialized, String platformId) {
        super(claims, clock, serialized, platformId);
        this.clock = clock;
        if (!CPForCCLicense.hasCCServiceAddonLicense(claims)) {
            throw new InvalidLicenseException("Invalid CP for CC license. It does not contain 'CP for CC' SKUs.");
        }
    }

    CPForCCLicense(JwtClaims claims, Time clock, String serialized) {
        this(claims, clock, serialized, null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getString());
        try {
            if (this.isExpired()) {
                sb.append(" expired on ").append(this.expirationDateString());
            } else {
                long remainingMillis = this.timeRemaining(TimeUnit.MILLISECONDS);
                long daysRemaining = TimeUnit.MILLISECONDS.toDays(remainingMillis);
                sb.append(" expires in ").append(daysRemaining).append(" days on ").append(this.expirationDateString());
            }
        }
        catch (Throwable t) {
            sb.append(" with invalid expiration");
        }
        sb.append(".");
        return sb.toString();
    }

    private String getString() {
        return CP_FOR_CC_LICENSE;
    }

    @Override
    public License.Type type() {
        return License.Type.ENTERPRISE;
    }

    @Override
    public License.DeploymentScope deploymentScope() {
        return License.DeploymentScope.CP_FOR_CC;
    }

    @Override
    public boolean isRenewalOf(License other) {
        if (!(other instanceof CPForCCLicense)) {
            return false;
        }
        CPForCCLicense otherLicense = (CPForCCLicense)other;
        return this.hasMatchingClaims(other, new String[0]) && otherLicense.updatedAtMillis() < this.updatedAtMillis() && otherLicense.expirationMillis() < this.expirationMillis();
    }

    private static boolean hasCCServiceAddonLicense(JwtClaims claims) {
        List ccServiceArray;
        if (claims == null) {
            throw new InvalidLicenseException("Invalid CP for CC license. Claims cannot be null.");
        }
        Object claimValue = claims.getClaimValue("addon");
        if (!(claimValue instanceof Map)) {
            return false;
        }
        Map addon = (Map)claimValue;
        Object ccServiceAddon = addon.get(LicenseAddonTypes.CC_SERVICE.getValue());
        if (!(ccServiceAddon instanceof List) || (ccServiceArray = (List)ccServiceAddon).isEmpty()) {
            return false;
        }
        return ccServiceArray.stream().allMatch(item -> {
            Map ccServiceMap;
            return item instanceof Map && (ccServiceMap = (Map)item).containsKey(SKU) && ccServiceMap.containsKey(EXPIRY_ON) && ccServiceMap.containsKey(ISSUED_AT);
        });
    }
}

