/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.logging.log4j;

import io.confluent.common.logging.LogRecordBuilder;
import io.confluent.common.logging.LogRecordStringBuilder;
import java.util.function.Supplier;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class StructuredJsonLayout
extends Layout {
    final Supplier<LogRecordBuilder<String>> logRecordBuilderFactory;

    public String format(LoggingEvent loggingEvent) {
        LogRecordBuilder<String> recordBuilder = this.logRecordBuilderFactory.get();
        return (String)recordBuilder.withLevel(loggingEvent.getLevel().toString()).withLoggerName(loggingEvent.getLoggerName()).withTimeMs(loggingEvent.getTimeStamp()).withMessageJson(loggingEvent.getRenderedMessage()).build();
    }

    public boolean ignoresThrowable() {
        return true;
    }

    public void activateOptions() {
    }

    public StructuredJsonLayout() {
        this(LogRecordStringBuilder::new);
    }

    StructuredJsonLayout(Supplier<LogRecordBuilder<String>> logRecordBuilderFactory) {
        this.logRecordBuilderFactory = logRecordBuilderFactory;
    }
}

