/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.OAuthBearerAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticatorConfig;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigDef;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class InstallOAuthSecurityHandler
implements Consumer<ServletContextHandler>,
Configurable {
    public static final String JWT_ISSUER = "Confluent";
    OAuthConfig config;

    public void configure(Map<String, ?> map) {
        this.config = new OAuthConfig(map);
    }

    @Override
    public void accept(ServletContextHandler context) {
        context.setSecurityHandler((SecurityHandler)this.createOAuthSecurityHandler());
    }

    private ConstraintSecurityHandler createOAuthSecurityHandler() {
        String realm = this.config.getString("authentication.realm");
        Map authenticatorOriginals = this.config.originals();
        ConstraintSecurityHandler handler = new ConstraintSecurityHandler();
        handler.addConstraintMapping(AuthUtil.createGlobalAuthConstraint((RestConfig)this.config));
        handler.setAuthenticator((Authenticator)new OAuthBearerAuthenticator());
        JwtLoginService jwtLoginService = new JwtLoginService(realm, new JwtAuthenticator(this.config.jwtAuthenticatorConfig()));
        handler.setLoginService((LoginService)jwtLoginService);
        handler.setIdentityService((IdentityService)new DefaultIdentityService());
        handler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)handler).addConstraintMapping(arg_0));
        return handler;
    }

    public static class OAuthConfig
    extends RestConfig {
        public static final String JWT_PUBLIC_KEY_PATH_CONFIG = "oauth.jwt.public.key.path";
        private static final String JWT_PUBLIC_KEY_PATH_DOC = "path to the public key expected for signed JWT OAuth tokens, or a directory that will be searched for public key files. Any file ending in '.pem' within the directory will be loaded.";
        private static final ConfigDef CONFIG = OAuthConfig.baseConfigDef().define("oauth.jwt.public.key.path", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "path to the public key expected for signed JWT OAuth tokens, or a directory that will be searched for public key files. Any file ending in '.pem' within the directory will be loaded.");

        public OAuthConfig(Map<?, ?> originals) {
            super(CONFIG, originals);
        }

        public JwtAuthenticatorConfig jwtAuthenticatorConfig(String prefix) {
            Map authConfig = this.originalsWithPrefix(prefix, true);
            authConfig.put("jwksLocation", this.get(JWT_PUBLIC_KEY_PATH_CONFIG));
            return new JwtAuthenticatorConfig(authConfig);
        }

        public JwtAuthenticatorConfig jwtAuthenticatorConfig() {
            return this.jwtAuthenticatorConfig("");
        }
    }
}

