/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.RestUserPrincipal;
import io.confluent.common.security.jetty.OAuthBearerAuthenticator;
import io.confluent.common.security.jetty.OAuthRequestData;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthOrBasicAuthenticator
extends LoginAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OAuthOrBasicAuthenticator.class);
    public static final String USE_JWT_LOGIN_SERVICE = "io.confluent.useJWTLoginService";
    public static final String METADATA_RESOURCE_URI = "/v1/metadata/id";
    private static final OAuthBearerAuthenticator oauth = new OAuthBearerAuthenticator();
    private final BasicAuthenticator basic;
    private final List<String> allowedNoAuthEndpoints = new ArrayList<String>();

    public OAuthOrBasicAuthenticator() {
        this(new BasicAuthenticator());
    }

    public OAuthOrBasicAuthenticator(BasicAuthenticator basicAuthenticator) {
        this(basicAuthenticator, Collections.emptyList());
    }

    public OAuthOrBasicAuthenticator(BasicAuthenticator basicAuthenticator, List<String> additionalNoAuthEndpoints) {
        this.basic = basicAuthenticator;
        this.allowedNoAuthEndpoints.add(METADATA_RESOURCE_URI);
        this.allowedNoAuthEndpoints.addAll(additionalNoAuthEndpoints);
    }

    public String getAuthMethod() {
        return "BEARER+BASIC";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        OAuthRequestData authRequestData;
        HttpServletRequest request = (HttpServletRequest)req;
        boolean requestIsForNoAuthEndpoint = this.allowedNoAuthEndpoints.stream().anyMatch(noAuthEndpoint -> request.getRequestURI().equalsIgnoreCase((String)noAuthEndpoint));
        if (requestIsForNoAuthEndpoint) {
            UserIdentity userIdentity = this._identityService.newUserIdentity(new Subject(), (Principal)new RestUserPrincipal(""), new String[0]);
            return new UserAuthentication(this.getAuthMethod(), userIdentity);
        }
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        if (log.isDebugEnabled() && !(authRequestData = new OAuthRequestData(request)).authInfoExists()) {
            log.debug("Authentication Header/token information missing in the request");
        }
        if (oauth.requestIsOath((HttpServletRequest)req)) {
            req.setAttribute(USE_JWT_LOGIN_SERVICE, (Object)true);
            return oauth.validateRequest(req, res, true);
        }
        return this.basic.validateRequest(req, res, true);
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        this.basic.setConfiguration(configuration);
        oauth.setConfiguration(configuration);
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }
}

