/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Request;

class ConnectConstraintSecurityHandler
extends ConstraintSecurityHandler {
    private static final Pattern CONNECT_INTERNAL_TASK_CONFIGS_ENDPOINT = Pattern.compile("/?connectors/([^/]+)/tasks/?");

    ConnectConstraintSecurityHandler() {
    }

    private static boolean isInternalRequest(HttpServletRequest request) {
        return request.getMethod().equalsIgnoreCase("POST") && CONNECT_INTERNAL_TASK_CONFIGS_ENDPOINT.matcher(request.getPathInfo()).matches();
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (ConnectConstraintSecurityHandler.isInternalRequest(request)) {
            this.getHandler().handle(pathInContext, baseRequest, request, response);
        } else {
            super.handle(pathInContext, baseRequest, request, response);
        }
    }
}

