/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.sasl;

import com.sun.security.auth.module.Krb5LoginModule;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.scram.ScramLoginModule;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaasConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(JaasConfigProvider.class);
    private static final JaasConfigProvider instance = new JaasConfigProvider();
    private static final Map<String, String> loginModuleToPrincipalKeyMap = new HashMap<String, String>();
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final String EQUALS = "=";
    private static final String SEMICOLON = ";";
    private final Map<String, JaasConfig> principalToJaasConfigMap = new HashMap<String, JaasConfig>();
    private static final Map<AppConfigurationEntry.LoginModuleControlFlag, String> controlFlagStringMap = new HashMap<AppConfigurationEntry.LoginModuleControlFlag, String>();

    private JaasConfigProvider() {
    }

    public static JaasConfigProvider getInstance() {
        return instance;
    }

    public void initialize() {
        this.principalToJaasConfigMap.clear();
        String jaasConfigFile = System.getProperty("java.security.auth.login.config");
        if (StringUtil.isBlank((String)jaasConfigFile)) {
            log.warn("Not initializing since the Jaas config file is not provided. Will attempt to use default settings and could fail in the broker.");
            return;
        }
        Configuration jaasConfig = Configuration.getConfiguration();
        AppConfigurationEntry[] appConfigurationEntries = jaasConfig.getAppConfigurationEntry("KafkaClient");
        if (appConfigurationEntries != null) {
            for (AppConfigurationEntry appConfigurationEntry : appConfigurationEntries) {
                String loginModule = appConfigurationEntry.getLoginModuleName();
                if (loginModuleToPrincipalKeyMap.containsKey(loginModule) && appConfigurationEntry.getOptions() != null && !appConfigurationEntry.getOptions().isEmpty()) {
                    StringBuilder jaasConfigBuilder = new StringBuilder(loginModule).append(SPACE);
                    jaasConfigBuilder.append(appConfigurationEntry.getControlFlag() != null ? controlFlagStringMap.get(appConfigurationEntry.getControlFlag()) : EMPTY);
                    TreeMap sortedOptions = new TreeMap(appConfigurationEntry.getOptions());
                    for (Map.Entry entry : sortedOptions.entrySet()) {
                        jaasConfigBuilder.append(SPACE).append(entry.getKey()).append(EQUALS).append("\"").append(entry.getValue()).append("\"");
                    }
                    jaasConfigBuilder.append(SEMICOLON);
                    String principal = (String)appConfigurationEntry.getOptions().get(loginModuleToPrincipalKeyMap.get(loginModule));
                    this.principalToJaasConfigMap.put(principal, new JaasConfig(loginModule, jaasConfigBuilder.toString(), appConfigurationEntry.getOptions()));
                    continue;
                }
                log.warn("Unsupported LoginModule for SASL {}", (Object)loginModule);
            }
        }
    }

    public JaasConfig getJaasConfig(String principal) {
        return this.principalToJaasConfigMap.get(principal);
    }

    static {
        loginModuleToPrincipalKeyMap.put(Krb5LoginModule.class.getName(), "principal");
        loginModuleToPrincipalKeyMap.put(PlainLoginModule.class.getName(), "username");
        loginModuleToPrincipalKeyMap.put(ScramLoginModule.class.getName(), "username");
        controlFlagStringMap.put(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, "optional");
        controlFlagStringMap.put(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, "required");
        controlFlagStringMap.put(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, "requisite");
        controlFlagStringMap.put(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, "requisite");
        controlFlagStringMap.put(AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, "sufficient");
    }

    public class JaasConfig {
        private String loginModule;
        private String configuration;
        private final Map<String, ?> options;

        public JaasConfig(String loginModule, String configuration, Map<String, ?> options) {
            this.loginModule = loginModule;
            this.configuration = configuration;
            this.options = options;
        }

        public String getLoginModule() {
            return this.loginModule;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public Object getOption(String key) {
            return this.options != null ? this.options.get(key) : null;
        }
    }
}

