/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import io.confluent.common.security.auth.AuthenticationModule;
import io.confluent.common.security.auth.RestAuthType;
import io.confluent.common.security.auth.RestUserPrincipal;
import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;

public final class JettyAuthenticationModule
implements AuthenticationModule {
    public static final JettyAuthenticationModule INSTANCE = new JettyAuthenticationModule();

    @Override
    public Principal authenticate(ContainerRequestContext containerRequestContext) {
        Principal userPrincipal = containerRequestContext.getSecurityContext().getUserPrincipal();
        return userPrincipal != null ? new RestUserPrincipal(userPrincipal.getName()) : null;
    }

    @Override
    public String getAuthScheme() {
        return RestAuthType.JETTY_AUTH.name();
    }
}

