/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class JwtPrincipal
implements Principal {
    private final OAuthBearerToken idToken;

    public JwtPrincipal(OAuthBearerToken idToken) {
        this.idToken = idToken;
    }

    @Override
    public String getName() {
        return this.idToken.principalName();
    }

    public Set<String> getScope() {
        return Collections.unmodifiableSet(this.idToken.scope());
    }

    public String getJwt() {
        return this.idToken.value();
    }
}

