/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import io.confluent.common.security.auth.AuthenticationModule;
import io.confluent.common.security.auth.RestAuthType;
import io.confluent.common.security.auth.RestUserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.security.auth.login.LoginException;
import javax.ws.rs.container.ContainerRequestContext;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslAuthenticationModule
implements AuthenticationModule {
    private static final Logger log = LoggerFactory.getLogger(SslAuthenticationModule.class);
    private final Optional<SslPrincipalMapper> principalMapperOpt;

    public SslAuthenticationModule(Optional<SslPrincipalMapper> principalMapper) {
        this.principalMapperOpt = principalMapper;
    }

    @Override
    public Principal authenticate(ContainerRequestContext containerRequestContext) throws LoginException {
        X509Certificate[] certs = (X509Certificate[])containerRequestContext.getProperty("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            throw new LoginException("Auth Certificate couldn't be found");
        }
        String mappedPrincipalName = this.mapPrincipalName(certs[0].getSubjectX500Principal().getName());
        return new RestUserPrincipal(mappedPrincipalName);
    }

    private String mapPrincipalName(String distinguishedName) throws LoginException {
        try {
            if (this.principalMapperOpt.isPresent()) {
                return this.principalMapperOpt.get().getName(distinguishedName);
            }
            return distinguishedName;
        }
        catch (IOException e) {
            log.error("Failed to map distinguished name {} to principal using custom rules", (Object)distinguishedName, (Object)e);
            throw new LoginException("Failed to map distinguished name " + distinguishedName + " to principal");
        }
    }

    @Override
    public String getAuthScheme() {
        return RestAuthType.SSL.name();
    }
}

