/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateAuthenticator
extends LoginAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(CertificateAuthenticator.class);

    public String getAuthMethod() {
        return "CLIENT_CERT";
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        log.debug("Processing certificate authentication");
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null) {
            certs = new X509Certificate[]{};
        }
        for (X509Certificate cert : certs) {
            if (cert == null) continue;
            log.debug("Trying presented certificate: " + cert.getSubjectDN());
            String username = cert.getSubjectX500Principal().getName();
            X509Certificate credentials = cert;
            UserIdentity user = this.getLoginService().login(username, (Object)credentials, req);
            if (user == null) continue;
            log.debug("Found eligible certificate: " + cert.getSubjectDN());
            return new UserAuthentication(this.getAuthMethod(), user);
        }
        log.debug("No eligible certificates found");
        return UserAuthentication.NOT_CHECKED;
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }
}

