/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.security.auth.client.rest.RestClient;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsBasicLoginService
extends AbstractLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdsBasicLoginService.class);
    private final String realmName;
    private RestClient restClient;

    public MdsBasicLoginService(Map<String, ?> map, String realmName) {
        this.realmName = realmName;
        this.restClient = new RestClient(map);
    }

    public UserIdentity login(String userName, Object credentials, ServletRequest request) {
        UserIdentity userIdentity = null;
        log.trace("Login attempt for user {}", (Object)userName);
        try {
            String userInfo = userName + ":" + credentials;
            OAuthBearerToken idToken = this.restClient.login(userInfo);
            if (idToken == null) {
                log.error("Login failed for " + userName);
                return null;
            }
            Subject subject = new Subject();
            JwtPrincipal principal = new JwtPrincipal(idToken);
            subject.getPrincipals().add(principal);
            userIdentity = this._identityService.newUserIdentity(subject, (Principal)principal, new String[0]);
            log.trace("User identity created on subject {}", (Object)subject);
        }
        catch (Exception e) {
            log.error("Login failed for " + userName, (Throwable)e);
        }
        return userIdentity;
    }

    public String getName() {
        return this.realmName;
    }

    protected AbstractLoginService.UserPrincipal loadUserInfo(String s) {
        throw new UnsupportedOperationException("loadUserInfo");
    }

    protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal userPrincipal) {
        throw new UnsupportedOperationException("loadRoleInfo");
    }

    void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }
}

