/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Objects;

public class CertificatePrincipal
implements Principal {
    private final String name;
    private final X509Certificate certificate;

    public CertificatePrincipal(String name, X509Certificate certificate) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(certificate);
        this.name = name;
        this.certificate = certificate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public String toString() {
        return "CertificatePrincipal{name='" + this.name + '\'' + ", certificate=" + this.certificate.getSubjectDN() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificatePrincipal that = (CertificatePrincipal)o;
        return this.name.equals(that.name) && this.certificate.equals(that.certificate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.certificate);
    }
}

