/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.metrics;

import io.confluent.rest.RestConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Time;

public abstract class AbstractMetricContainer {
    private static final String JMX_PREFIX = "io.confluent.common.security.jetty";

    protected static MetricsContext buildMetricsContext(RestConfig config) {
        Map metadata = config.originalsWithPrefix("metrics.context.");
        metadata.put("resource.type", "auth");
        return new KafkaMetricsContext(JMX_PREFIX, metadata);
    }

    protected static Metrics buildMetrics(RestConfig config, MetricsContext metricsContext) {
        List reporters = config.getConfiguredInstances(config.getList("metric.reporters"), MetricsReporter.class, new HashMap());
        reporters.add(AbstractMetricContainer.getJmxReporter(config));
        MetricConfig metricConfig = new MetricConfig().samples(config.getInt("metrics.num.samples").intValue()).timeWindow(config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
        return new Metrics(metricConfig, reporters, Time.SYSTEM, metricsContext);
    }

    private static MetricsReporter getJmxReporter(RestConfig config) {
        JmxReporter reporter = new JmxReporter();
        reporter.configure(config.originals());
        return reporter;
    }
}

