/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.util;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);

    public static Set<String> getGroupsFromJwtPrincipal(JwtPrincipal principal) {
        if (Objects.equals(principal.jwtClaims().get("iss"), "Confluent")) {
            return JwtUtils.getGroupsFromJwtPrincipal(principal, "groups");
        }
        return JwtUtils.getGroupsFromJwtPrincipal(principal, principal.getGroupsClaimName());
    }

    private static Set<String> getGroupsFromJwtPrincipal(JwtPrincipal principal, String groupsClaimName) {
        if (Objects.isNull(groupsClaimName) || groupsClaimName.isEmpty()) {
            return Collections.emptySet();
        }
        List groupsObj = principal.jwtClaims().getOrDefault(groupsClaimName, Collections.emptyList());
        if (Objects.nonNull(groupsObj) && !(groupsObj instanceof List)) {
            throw new IllegalArgumentException(String.format("Unexpected type of groups in jwt. Expected type: %s, Actual type: %s", List.class, groupsObj.getClass()));
        }
        HashSet<String> groups = new HashSet<String>();
        for (Object groupObj : groupsObj) {
            if (!(groupObj instanceof String)) {
                throw new IllegalArgumentException(String.format("Unexpected type of %s. Expected type: %s, Actual type: %s", groupsClaimName, String.class, groupObj.getClass()));
            }
            groups.add((String)groupObj);
        }
        return groups;
    }

    public static CloseableVerificationKeyResolver createJwksVerificationKeyResolver(HttpsJwks httpsIdpJwks) {
        final HttpsJwksVerificationKeyResolver httpsJwksVerificationKeyResolver = new HttpsJwksVerificationKeyResolver(httpsIdpJwks);
        return new CloseableVerificationKeyResolver(){

            public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
                return httpsJwksVerificationKeyResolver.resolveKey(jws, nestingContext);
            }

            public void close() {
            }
        };
    }

    public static CloseableVerificationKeyResolver getJwtKeyResolver(String idpJwksEndpoint, String sslEndpointIdentificationAlgorithm, SslContextFactory sslContextFactory) {
        if (Objects.nonNull(sslContextFactory) && !sslContextFactory.isRunning()) {
            try {
                sslContextFactory.start();
            }
            catch (Exception e) {
                throw new IllegalStateException("SSL Context Factory failed to start. One of the reason could be wrong truststore and keystore password.", e);
            }
        }
        Get get = new Get();
        if (Objects.nonNull(sslContextFactory) && Objects.nonNull(sslContextFactory.getSslContext())) {
            log.info("Setting up custom SSLContext for OAuth JWT authenticator.");
            get.setSslSocketFactory(sslContextFactory.getSslContext().getSocketFactory());
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{sslEndpointIdentificationAlgorithm})) {
                log.info("Provided ssl.endpoint.identification.algorithm={}. Skipping hostname verification in OAuth JWT authenticator.", (Object)sslEndpointIdentificationAlgorithm);
                get.setHostnameVerifier((s, sslSession) -> true);
            }
        }
        HttpsJwks httpsJwks = new HttpsJwks(idpJwksEndpoint);
        httpsJwks.setSimpleHttpGet((SimpleGet)get);
        return JwtUtils.createJwksVerificationKeyResolver(httpsJwks);
    }
}

