/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import java.security.cert.X509Certificate;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateAuthenticator
extends LoginAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(CertificateAuthenticator.class);

    public String getAuthenticationType() {
        return "CLIENT_CERT";
    }

    public AuthenticationState validateRequest(Request req, Response res, Callback callback) throws ServerAuthException {
        log.debug("Processing certificate authentication");
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("jakarta.servlet.request.X509Certificate");
        if (certs == null) {
            certs = new X509Certificate[]{};
        }
        for (X509Certificate cert : certs) {
            if (cert == null) continue;
            log.debug("Trying presented certificate: {}", (Object)cert.getSubjectX500Principal());
            String username = cert.getSubjectX500Principal().getName();
            UserIdentity user = this.getLoginService().login(username, (Object)cert, req, arg_0 -> ((Request)req).getSession(arg_0));
            if (user == null) continue;
            log.debug("Found eligible certificate: {}", (Object)cert.getSubjectX500Principal());
            return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), user);
        }
        log.debug("No eligible certificates found");
        return AuthenticationState.CHALLENGE;
    }
}

