/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.ssl;

import io.confluent.common.security.ssl.PrincipalAliasedX509KeyManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public final class PrincipalAliasKeyManagerSpi
extends KeyManagerFactorySpi {
    private X509KeyManager defaultKeyManager = null;
    private X509ExtendedKeyManager principalAliasKeyManager = null;

    @Override
    protected void engineInit(KeyStore keyStore, char[] chars) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        HashMap<String, String> userToAliasMap = new HashMap<String, String>();
        KeyStoreParser.parse(keyStore, userToAliasMap);
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(keyStore, chars);
        KeyManager[] keyManagers = factory.getKeyManagers();
        if (keyManagers == null || keyManagers.length == 0) {
            throw new NoSuchAlgorithmException("The default algorithm :" + KeyManagerFactory.getDefaultAlgorithm() + " produced no key managers");
        }
        for (KeyManager keyManager : keyManagers) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            this.defaultKeyManager = (X509KeyManager)keyManager;
            break;
        }
        this.principalAliasKeyManager = new PrincipalAliasedX509KeyManager(userToAliasMap, this.defaultKeyManager);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        return new KeyManager[]{this.principalAliasKeyManager};
    }

    public static class KeyStoreParser {
        public static void parse(KeyStore keyStore, Map<String, String> userToAliasMap) throws KeyStoreException {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                userToAliasMap.put(cert.getSubjectX500Principal().getName(), alias);
            }
        }
    }
}

