/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.util;

import io.confluent.common.security.jetty.CertificateAuthenticator;
import io.confluent.common.security.jetty.CertificateLoginService;
import io.confluent.common.security.jetty.CompositeAuthenticator;
import io.confluent.common.security.jetty.CompositeLoginService;
import io.confluent.common.security.jetty.JwtLoginService;
import io.confluent.common.security.jetty.JwtWithFallbackLoginService;
import io.confluent.common.security.jetty.MdsBasicLoginService;
import io.confluent.common.security.jetty.MultiJwtLoginService;
import io.confluent.common.security.jetty.MultiJwtWithFallbackLoginService;
import io.confluent.common.security.jetty.OAuthOrBasicAuthenticator;
import io.confluent.common.security.jetty.initializer.AuthenticationHandler;
import io.confluent.common.security.jetty.initializer.ConnectConstraintSecurityHandler;
import io.confluent.common.security.metrics.MetricsContainer;
import io.confluent.common.security.util.JwtUtils;
import io.confluent.common.security.util.Utils;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactory;
import io.confluent.rest.auth.AuthUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger log = LoggerFactory.getLogger(AuthUtils.class);

    public static LoginAuthenticator createCompositeAuthenticator(AuthenticationHandler.SecurityHandlerConfig config) {
        return new CompositeAuthenticator((Authenticator)new OAuthOrBasicAuthenticator(), (Authenticator)new CertificateAuthenticator(), config.allowAnonymousUser());
    }

    public static LoginAuthenticator createCompositeAuthenticator(AuthenticationHandler.SecurityHandlerConfig config, BasicAuthenticator basicAuthenticator) {
        return new CompositeAuthenticator((Authenticator)new OAuthOrBasicAuthenticator(basicAuthenticator), (Authenticator)new CertificateAuthenticator(), config.allowAnonymousUser());
    }

    public static ConstraintSecurityHandler getOAuthSecurityHandler(AuthenticationHandler.SecurityHandlerConfig config) {
        String realm = config.getString("authentication.realm");
        ConstraintSecurityHandler securityHandler = AuthUtils.conditionalConstraintSecurityHandler(config);
        securityHandler.setRealmName(realm);
        ConstraintMapping globalConstraint = AuthUtil.createGlobalAuthConstraint((RestConfig)config);
        log.debug("Configured Jetty authentication roles: {}", (Object)String.join((CharSequence)",", globalConstraint.getConstraint().getRoles()));
        securityHandler.addConstraintMapping(globalConstraint);
        securityHandler.setIdentityService((IdentityService)new DefaultIdentityService());
        return securityHandler;
    }

    private static ConstraintSecurityHandler conditionalConstraintSecurityHandler(AuthenticationHandler.SecurityHandlerConfig config) {
        return config.exposeInternalConnectEndpoints() ? new ConnectConstraintSecurityHandler() : new ConstraintSecurityHandler();
    }

    public static LoginService createX509LoginService(AuthenticationHandler.SecurityHandlerConfig config) {
        return AuthUtils.createX509LoginService(config, null);
    }

    public static LoginService createX509LoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
        SslPrincipalMapper principalMapper = AuthUtils.createSslPrincipalMapper(config);
        CertificateLoginService loginService = new CertificateLoginService();
        loginService.setSslPrincipalMapper(principalMapper);
        if (Objects.nonNull(metricsContainer)) {
            loginService.withMetricsContainer(metricsContainer);
        }
        return loginService;
    }

    public static SslPrincipalMapper createSslPrincipalMapper(AuthenticationHandler.SecurityHandlerConfig config) {
        String rules = config.getString("auth.ssl.principal.mapping.rules");
        return SslPrincipalMapper.fromRules((String)rules);
    }

    public static boolean isClientAuthEnabled(AuthenticationHandler.SecurityHandlerConfig config) {
        return !config.getString("ssl.client.authentication").equals("NONE");
    }

    public static boolean impersonationTokenValidation(AuthenticationHandler.SecurityHandlerConfig config) {
        return config.getBoolean("token.impersonation.validation");
    }

    public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config) {
        return MdsBasicLoginServiceProxy.getMdsBasicLoginService(config);
    }

    public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
        return MdsBasicLoginServiceProxy.getMdsBasicLoginService(config, metricsContainer);
    }

    public static JwtLoginService getConfluentJwtLoginService(String realm, String issuer, String publicKeyPath, MetricsContainer metricsContainer) {
        return new JwtLoginService(realm, issuer, publicKeyPath, "").withMetricsContainer(metricsContainer, issuer);
    }

    public static JwtLoginService getIdpJwtLoginService(String realm, String issuer, List<String> audience, String subClaimName, String groupsClaimName, AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
        String idpJwksEndpoint = Utils.getBaseString("oauthbearer.jwks.endpoint.url", config);
        String sslEndpointIdentificationAlgorithm = Utils.getBaseString("ssl.endpoint.identification.algorithm", config);
        SslContextFactory sslContextFactory = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{config.getBaseSslConfig().getTrustStorePath()}) ? null : SslFactory.createSslContextFactory((SslConfig)config.getBaseSslConfig());
        CloseableVerificationKeyResolver jwksKeyResolver = JwtUtils.getJwtKeyResolver(idpJwksEndpoint, sslEndpointIdentificationAlgorithm, sslContextFactory);
        Map<String, Boolean> claimOptions = AuthUtils.getClaimOptions(config);
        JwtAuthenticator authenticator = new JwtAuthenticator(issuer, jwksKeyResolver, audience, claimOptions);
        return new JwtLoginService(realm, authenticator, subClaimName, groupsClaimName).withMetricsContainer(metricsContainer);
    }

    public static BasicAuthenticator getBasicAuthenticatorForNonJettyUsage() {
        return new BasicAuthenticator(){

            public UserIdentity login(String username, Object password, Request request, Response response) {
                return this._loginService.login(username, password, request, arg_0 -> ((Request)request).getSession(arg_0));
            }
        };
    }

    public static LoginService getCompositeLoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer, Logger log) {
        LoginService httpLoginService = AuthUtils.createHttpLoginService(config, metricsContainer, log);
        LoginService x509LoginService = AuthUtils.createX509LoginService(config, metricsContainer);
        if (httpLoginService == null) {
            log.warn("Http login service not configured, defaulting to x509 login service");
            return x509LoginService;
        }
        return new CompositeLoginService(httpLoginService, x509LoginService, AuthUtils.isClientAuthEnabled(config), AuthUtils.impersonationTokenValidation(config));
    }

    public static void configureAuthenticatorForNonJettyUsage(final Authenticator authenticator, final String realm, final LoginService loginService) {
        loginService.setIdentityService((IdentityService)new DefaultIdentityService());
        if (loginService instanceof AbstractLifeCycle) {
            try {
                ((AbstractLifeCycle)loginService).start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        authenticator.setConfiguration(new Authenticator.Configuration(){

            public String getAuthenticationType() {
                return authenticator.getAuthenticationType();
            }

            public String getRealmName() {
                return realm;
            }

            public String getParameter(String s) {
                throw new UnsupportedOperationException();
            }

            public Set<String> getParameterNames() {
                throw new UnsupportedOperationException();
            }

            public LoginService getLoginService() {
                return loginService;
            }

            public IdentityService getIdentityService() {
                return loginService.getIdentityService();
            }

            public boolean isSessionRenewedOnAuthentication() {
                return false;
            }

            public int getSessionMaxInactiveIntervalOnAuthentication() {
                return 0;
            }
        });
    }

    public static LoginService createHttpLoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer, Logger log) {
        String realm = config.getString("authentication.realm");
        String publicKeyPath = config.getString("public.key.path");
        String issuer = config.getString("token.issuer");
        String idpIssuer = Utils.getBaseString("oauthbearer.expected.issuer", config);
        String subClaimName = Utils.getBaseString("oauthbearer.sub.claim.name", config);
        String groupsClaimName = Utils.getBaseString("oauthbearer.groups.claim.name", config);
        List<String> audience = Utils.getBaseList("oauthbearer.expected.audience", config);
        boolean isConfluentOAuthEnabled = AuthUtils.isConfluentOAuthEnabled(config, log);
        boolean isIdpOAuthEnabled = AuthUtils.isIdpOAuthEnabled(config, log);
        log.debug("Confluent OAuth enabled: {}, IDP Oauth is enabled: {}", (Object)isConfluentOAuthEnabled, (Object)isIdpOAuthEnabled);
        if (!isConfluentOAuthEnabled && !isIdpOAuthEnabled) {
            log.error("Neither Confluent OAuth nor IDP OAuth is enabled. Please check your configuration.");
            return null;
        }
        if (isConfluentOAuthEnabled && !isIdpOAuthEnabled) {
            return new JwtWithFallbackLoginService(AuthUtils.getConfluentJwtLoginService(realm, issuer, publicKeyPath, metricsContainer), (LoginService)AuthUtils.getMdsBasicLoginService(config, metricsContainer));
        }
        if (!isConfluentOAuthEnabled) {
            return AuthUtils.getIdpJwtLoginService(realm, idpIssuer, audience, subClaimName, groupsClaimName, config, metricsContainer);
        }
        return new MultiJwtWithFallbackLoginService(new MultiJwtLoginService(AuthUtils.getConfluentJwtLoginService(realm, issuer, publicKeyPath, metricsContainer), AuthUtils.getIdpJwtLoginService(realm, idpIssuer, audience, subClaimName, groupsClaimName, config, metricsContainer)), (LoginService)AuthUtils.getMdsBasicLoginService(config, metricsContainer));
    }

    private static boolean isConfluentOAuthEnabled(AuthenticationHandler.SecurityHandlerConfig config, Logger log) {
        String publicKeyPath = config.getString("public.key.path");
        log.debug("Configured public key path for token validation: {}", (Object)publicKeyPath);
        return StringUtils.isNotEmpty((CharSequence)publicKeyPath);
    }

    private static boolean isIdpOAuthEnabled(AuthenticationHandler.SecurityHandlerConfig config, Logger log) {
        String idpIssuer = Utils.getBaseString("oauthbearer.expected.issuer", config);
        String idpKeyUrl = Utils.getBaseString("oauthbearer.jwks.endpoint.url", config);
        log.debug("Configured IDP issuer: {}, IDP key url: {}", (Object)idpIssuer, (Object)idpKeyUrl);
        return StringUtils.isNotEmpty((CharSequence)idpIssuer) && StringUtils.isNotEmpty((CharSequence)idpKeyUrl);
    }

    private static Map<String, Boolean> getClaimOptions(AuthenticationHandler.SecurityHandlerConfig config) {
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>();
        configMap.put("jtiRequired", config.getBoolean("oauthbearer.jti.validation.enabled"));
        configMap.put("iatRequired", config.getBoolean("oauthbearer.iat.validation.enabled"));
        return configMap;
    }

    static class MdsBasicLoginServiceProxy {
        MdsBasicLoginServiceProxy() {
        }

        public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config) {
            return MdsBasicLoginServiceProxy.getMdsBasicLoginService(config, null);
        }

        public static MdsBasicLoginService getMdsBasicLoginService(AuthenticationHandler.SecurityHandlerConfig config, MetricsContainer metricsContainer) {
            String realm = config.getString("authentication.realm");
            return new MdsBasicLoginService(config.originals(), realm).withMetricsContainer(metricsContainer);
        }
    }
}

