/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import io.confluent.common.security.auth.AuthenticationModule;
import io.confluent.common.security.auth.JettyAuthenticationModule;
import io.confluent.common.security.auth.RestAuthType;
import io.confluent.common.security.auth.SslAuthenticationModule;
import java.util.Optional;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;

public final class AuthenticationModuleFactory {
    private static final AuthenticationModuleFactory instance = new AuthenticationModuleFactory();

    private AuthenticationModuleFactory() {
    }

    public static AuthenticationModuleFactory getInstance() {
        return instance;
    }

    public AuthenticationModule getAuthenticationModule(RestAuthType restAuthType, Optional<SslPrincipalMapper> principalMapper) {
        switch (restAuthType) {
            case SSL: {
                return new SslAuthenticationModule(principalMapper);
            }
            case JETTY_AUTH: {
                return JettyAuthenticationModule.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid authentication type " + String.valueOf((Object)restAuthType));
    }
}

