/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Message;
import io.confluent.metrics.YammerMetricsUtils;
import io.confluent.metrics.record.ConfluentMetric;
import java.util.Map;

public class KafkaMetricsUtils {
    public static Iterable<YammerMetricsUtils.YammerMetric> kafkaMetricsWrapperIterable(Iterable<? extends Message> list) {
        return FluentIterable.from(list).transformAndConcat((Function)new Function<Message, Iterable<? extends YammerMetricsUtils.YammerMetric>>(){

            public Iterable<? extends YammerMetricsUtils.YammerMetric> apply(Message input) {
                if (input == null) {
                    throw new IllegalArgumentException("Invalid null input");
                }
                if (input instanceof ConfluentMetric.KafkaMeasurable) {
                    return ImmutableList.of((Object)KafkaMetricsUtils.forMessage((ConfluentMetric.KafkaMeasurable)input));
                }
                throw new IllegalArgumentException("Unknown message type " + input.getClass());
            }
        });
    }

    public static YammerMetricsUtils.YammerMetric forMessage(ConfluentMetric.KafkaMeasurable metric) {
        return new KafkaMetricWrapper(metric);
    }

    public static class KafkaMetricWrapper
    implements YammerMetricsUtils.YammerMetric {
        protected final ConfluentMetric.KafkaMeasurable kafkaMeasurable;

        public KafkaMetricWrapper(ConfluentMetric.KafkaMeasurable kafkaMeasurable) {
            this.kafkaMeasurable = kafkaMeasurable;
        }

        @Override
        public String getName() {
            return this.kafkaMeasurable.getMetricName().getName();
        }

        @Override
        public Map<String, String> getTags() {
            return this.kafkaMeasurable.getMetricName().getTagsMap();
        }

        @Override
        public long longAggregate() {
            return (long)this.kafkaMeasurable.getValue();
        }

        @Override
        public double doubleAggregate() {
            return this.kafkaMeasurable.getValue();
        }
    }
}

