/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.serializers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.confluent.serializers.UberSerde;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSerde
implements UberSerde<String> {
    private static final Logger log = LoggerFactory.getLogger(StringSerde.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final Gson gson = new Gson();

    @Override
    public Class<String> type() {
        return String.class;
    }

    @Override
    public byte[] serialize(String string) {
        if (string == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(125);
            out.write(string.getBytes(CHARSET));
            return out.toByteArray();
        }
        catch (Exception e) {
            String errMsg = "Error serializing string message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    public byte[] serialize(String topic, String string) {
        return this.serialize(string);
    }

    @Override
    public String deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            byte magic = buffer.get();
            if (125 != magic) {
                String errMsg = String.format("Tried to deserialize message with unknown magic byte %s", magic);
                log.error(errMsg);
                throw new SerializationException(errMsg);
            }
            return new String(Arrays.copyOfRange(buffer.array(), 1, buffer.array().length), CHARSET);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            String errMsg = "Error deserializing string message";
            log.error(errMsg, (Throwable)e);
            throw new SerializationException(errMsg, (Throwable)e);
        }
    }

    public String deserialize(String topic, byte[] bytes) {
        return this.deserialize(bytes);
    }

    @Override
    public void configure(Map<String, ?> map, boolean b) {
    }

    public Serializer<String> serializer() {
        return this;
    }

    public Deserializer<String> deserializer() {
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public byte[] fromJson(String json) {
        String string = (String)this.gson.fromJson(json, String.class);
        return this.serialize(string);
    }

    @Override
    public String toJson(String string) {
        return this.gson.toJson((JsonElement)new JsonPrimitive(string));
    }
}

