/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import io.confluent.C3Version;
import io.confluent.common.config.AbstractConfig;
import io.confluent.common.config.ConfigDef;
import io.confluent.common.config.ConfigUtils;
import io.confluent.controlcenter.validators.StringNotPrefixValidator;
import io.confluent.controlcenter.validators.WarningValidator;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.StreamsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlCenterConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ControlCenterConfig.class);
    public static final String CONFLUENT_CONTROLCENTER_PREFIX = "confluent.controlcenter.";
    public static final String CONFLUENT_CONTROLCENTER_KSTREAMS_PREFIX = "confluent.controlcenter.streams.";
    public static final String CONFLUENT_CONTROLCENTER_REST_PREFIX = "confluent.controlcenter.rest.";
    public static final String CONFLUENT_CONTROLCENTER_EMAIL_PREFIX = "confluent.controlcenter.mail.";
    public static final String CONFLUENT_CONTROLCENTER_ALERT_PREFIX = "confluent.controlcenter.alert.";
    public static final String CONFLUENT_CONTROLCENTER_CONNECT_PREFIX = "confluent.controlcenter.connect.";
    public static final String CONFLUENT_MONITORING_INTERCEPTOR_PREFIX = "confluent.monitoring.interceptor.";
    public static final String CONFLUENT_CONTROLCENTER_KSQL_PREFIX = "confluent.controlcenter.ksql.";
    public static final String CONFLUENT_CONTROLCENTER_KAFKA_PREFIX = "confluent.controlcenter.kafka.";
    public static final int DEFAULT_CONTROL_CENTER_INPUT_TOPIC_PARTITIONS = 12;
    public static final int DEFAULT_CONTROL_CENTER_INPUT_TOPIC_REPLICATION = 3;
    public static final long DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_MS = TimeUnit.DAYS.toMillis(3L);
    public static final int DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_BYTES = -1;
    public static final long DEFAULT_CONTROL_CENTER_INPUT_TOPIC_SKIP_BACKLOG_MIN = 15L;
    public static final String CONTROL_CENTER_NAME_CONFIG = "confluent.controlcenter.name";
    public static final String DEFAULT_CONTROL_CENTER_NAME = "_confluent-controlcenter-" + C3Version.getVersion().getMajorVersion() + "-" + C3Version.getVersion().getMinorVersion() + "-" + C3Version.getVersion().getPatchVersion();
    protected static final String CONTROL_CENTER_NAME_DOC = "Control Center Name. All internal Topics will be prepended with this value.";
    public static final String CONTROL_CENTER_ID_CONFIG = "confluent.controlcenter.id";
    public static final String DEFAULT_CONTROL_CENTER_ID = "1";
    protected static final String CONTROL_CENTER_ID_DOC = "Control Center ID";
    public static final String CONTROL_CENTER_TOPIC_CONFIG = "confluent.monitoring.interceptor.topic";
    public static final String DEFAULT_CONTROL_CENTER_TOPIC = "_confluent-monitoring";
    protected static final String CONTROL_CENTER_TOPIC_DOC = "The Kafka topic that stores monitoring interceptor data. This setting must match the ``confluent.monitoring.interceptor.topic`` configuration used by the interceptors in your application. Usually you should not change this setting unless you are running multiple instances of Control Center with client monitoring interceptor data being reported to the same Kafka cluster.";
    public static final String CONFLUENT_METRICS_PREFIX = "confluent.metrics.";
    public static final String CONTROL_CENTER_METRICS_TOPIC_CONFIG = "confluent.metrics.topic";
    public static final String DEFAULT_CONTROL_CENTER_METRICS_TOPIC = "_confluent-metrics";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_DOC = "The topic the metrics reporter publishes its metrics to";
    public static final String CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT = "confluent.controlcenter.internal.streams.start.timeout";
    public static final long DEFAULT_CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT = TimeUnit.HOURS.toMillis(6L);
    protected static final String CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT_DOC = "Timeout when starting internal streams job in ms";
    public static final String CONTROL_CENTER_INTERNAL_PARTITIONS_CONFIG = "confluent.controlcenter.internal.topics.partitions";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_PARTITIONS = 4;
    protected static final String CONTROL_CENTER_INTERNAL_PARTITIONS_DOC = "Partition count for internal topics";
    public static final String CONTROL_CENTER_INTERNAL_REPLICATION_CONFIG = "confluent.controlcenter.internal.topics.replication";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_REPLICATION = 3;
    protected static final String CONTROL_CENTER_INTERNAL_REPLICATION_DOC = "Replication factor used internally by Control Center. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_INTERNAL_RETENTION_MS_CONFIG = "confluent.controlcenter.internal.topics.retention.ms";
    public static final long DEFAULT_CONTROL_CENTER_INTERNAL_RETENTION_MS = TimeUnit.DAYS.toMillis(7L);
    protected static final String CONTROL_CENTER_INTERNAL_RETENTION_MS_DOC = "Retention ms for internal topics";
    public static final String CONTROL_CENTER_INTERNAL_RETENTION_BYTES_CONFIG = "confluent.controlcenter.internal.topics.retention.bytes";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_RETENTION_BYTES = -1;
    protected static final String CONTROL_CENTER_INTERNAL_RETENTION_BYTES_DOC = "Retention bytes for internal topics";
    public static final String CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_CONFIG = "confluent.controlcenter.internal.topics.changelog.segment.bytes";
    public static final int DEFAULT_CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES = 0x8000000;
    protected static final String CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_DOC = "Segment size in bytes for internal changelog topics";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_CONFIG = "confluent.monitoring.interceptor.topic.partitions";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_DOC = "Number of partitions for the monitoring interceptor data topic";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_CONFIG = "confluent.monitoring.interceptor.topic.replication";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_DOC = "Replication factor for monitoring topic. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_CONFIG = "confluent.monitoring.interceptor.topic.retention.ms";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_DOC = "Retention ms for monitoring topic";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_CONFIG = "confluent.monitoring.interceptor.topic.retention.bytes";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_DOC = "Retention bytes for monitoring topic";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_SKIP_BACKLOG_MIN_CONFIG = "confluent.monitoring.interceptor.topic.skip.backlog.minutes";
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_SKIP_BACKLOG_MIN_DOC = "Start processing backlog from minutes ago and skip older data";
    public static final String CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_CONFIG = "confluent.monitoring.interceptor.topic.config.validate";
    public static final boolean DEFAULT_CONTROL_CENTER_MONITORING_TOPIC_VALIDATE = false;
    protected static final String CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_DOC = "Enforces partitions and replication factor settings on the monitoring topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_CONFIG = "confluent.metrics.topic.partitions";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_DOC = "Partition count for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_REPLICATION_CONFIG = "confluent.metrics.topic.replication";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_REPLICATION_DOC = "Replication factor for metrics topic. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_CONFIG = "confluent.metrics.topic.retention.ms";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_DOC = "Retention ms for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_CONFIG = "confluent.metrics.topic.retention.bytes";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_DOC = "Retention bytes for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_CONFIG = "confluent.metrics.topic.max.message.bytes";
    public static final int DEFAULT_CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES = 0xA00000;
    protected static final String CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_DOC = "Maximum message size for metrics topic";
    public static final String CONTROL_CENTER_METRICS_TOPIC_SKIP_BACKLOG_MIN_CONFIG = "confluent.metrics.topic.skip.backlog.minutes";
    protected static final String CONTROL_CENTER_METRICS_TOPIC_SKIP_BACKLOG_MIN_DOC = "Start processing backlog from minutes ago and skip older data";
    public static final String CONTROL_CENTER_METRICS_TOPIC_VALIDATE_CONFIG = "confluent.metrics.topic.config.validate";
    public static final boolean DEFAULT_CONTROL_CENTER_METRICS_TOPIC_VALIDATE = false;
    protected static final String CONTROL_CENTER_METRICS_TOPIC_VALIDATE_DOC = "Enforces partitions and replication factor settings on the metrics topic";
    public static final String CONTROL_CENTER_LICENSE_CONFIG = "confluent.license";
    protected static final String CONTROL_CENTER_LICENSE_DOC = "License";
    public static final String CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String DEFAULT_CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG = "localhost:9092";
    public static final String CONTROL_CENTER_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String CONTROL_CENTER_DATA_DIR = "confluent.controlcenter.data.dir";
    public static final String DEFAULT_CONTROL_CENTER_DATA_DIR = "/var/lib/confluent-control-center";
    protected static final String CONTROL_CENTER_DATA_DIR_DOC = "Location for Control Center specific data";
    public static final String CONTROL_CENTER_SESSION_TIMEOUT_MS_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.consumerPrefix((String)"session.timeout.ms");
    public static final int DEFAULT_CONTROL_CENTER_SESSION_TIMEOUT_MS_CONFIG = 60000;
    protected static final String CONTROL_CENTER_SESSION_TIMEOUT_MS_DOC = "The timeout used to detect a consumer failure";
    public static final String CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG = "confluent.controlcenter.streams.cache.max.bytes.buffering";
    public static final long DEFAULT_CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG = 0x40000000L;
    protected static final String CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG_DOC = "Maximum number of memory bytes to be used for buffering across all threads";
    public static final String CONTROL_CENTER_STREAMS_RETRIES_CONFIG = "confluent.controlcenter.streams.retries";
    public static final int DEFAULT_CONTROL_CENTER_STREAMS_RETRIES_CONFIG = Integer.MAX_VALUE;
    protected static final String CONTROL_CENTER_RETRIES_DOC = "Number of retries in case of streams metadata request failure";
    public static final String CONTROL_CENTER_PRODUCER_RETRIES_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"retries");
    public static final int DEFAULT_CONTROL_CENTER_PRODUCER_RETRIES_CONFIG = Integer.MAX_VALUE;
    protected static final String CONTROL_CENTER_PRODUCER_RETRIES_DOC = "Number of retries in case of production failure";
    public static final String CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"retry.backoff.ms");
    public static final long DEFAULT_CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_CONFIG = 100L;
    protected static final String CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_DOC = "Time to wait before retrying in case of production failure";
    public static final String CONTROL_CENTER_COMPRESSION_TYPE_CONFIG = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"compression.type");
    public static final String DEFAULT_CONTROL_CENTER_COMPRESSION_TYPE_CONFIG = "lz4";
    protected static final String CONTROL_CENTER_COMPRESSION_TYPE_DOC = "Compression type to use for internal topics";
    public static final String CONTROL_CENTER_PRODUCER_LINGER_MS = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"linger.ms");
    public static final int DEFAULT_CONTROL_CENTER_PRODUCER_LINGER_MS = 500;
    protected static final String CONTROL_CENTER_PRODUCER_LINGER_MS_DOC = "linger.ms used for internal producers.";
    public static final String CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"max.block.ms");
    public static final long DEFAULT_CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS = Long.MAX_VALUE;
    protected static final String CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS_DOC = "max.block.ms used for internal producers.";
    public static final String CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS = "confluent.controlcenter.streams." + StreamsConfig.producerPrefix((String)"delivery.timeout.ms");
    public static final int DEFAULT_CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS = Integer.MAX_VALUE;
    protected static final String CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS_DOC = "delivery.timeout.ms used for internal producers.";
    public static final String CONTROL_CENTER_PARALLELISM = "confluent.controlcenter.streams.num.stream.threads";
    public static final Integer DEFAULT_CONTROL_CENTER_PARALLELISM = 8;
    protected static final String CONTROL_CENTER_PARALLELISM_DOC = "The number of threads to execute stream processing";
    public static final String CONTROL_CENTER_REST_PORT = "confluent.controlcenter.rest.port";
    public static final Integer DEFAULT_CONTROL_CENTER_REST_PORT = 9021;
    protected static final String CONTROL_CENTER_REST_PORT_DOC = "DEPRECATED: port to listen on for new HTTP connections. Use listeners instead.";
    @Deprecated
    public static final String CONTROL_CENTER_CONNECT_CLUSTER = "confluent.controlcenter.connect.cluster";
    protected static final String CONTROL_CENTER_CONNECT_CLUSTER_DOC = "(Deprecated) Comma-separated list of URLs for the Connect cluster";
    @Deprecated
    public static final String CONTROL_CENTER_CONNECT_TIMEOUT = "confluent.controlcenter.connect.timeout";
    @Deprecated
    public static final String CONTROL_CENTER_CONNECT_TIMEOUT_MS = "confluent.controlcenter.connect.timeout.ms";
    public static final Long DEFAULT_CONTROL_CENTER_CONNECT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(15L);
    protected static final String CONTROL_CENTER_CONNECT_TIMEOUT_MS_DOC = "Timeout in millis for calls to connect cluster";
    public static final String CONTROL_CENTER_DISPLAY_HOST_PREFIX = "confluent.controlcenter.rest.advertised.url";
    public static final String DEFAULT_CONTROL_CENTER_DISPLAY_HOST_PREFIX = "";
    protected static final String CONTROL_CENTER_DISPLAY_HOST_PREFIX_DOC = "Externally visible host. C3 uses this as an override to rest.listeners when generating urls for external communications, e.g. emails.";
    public static final String CONTROL_CENTER_REST_COMPRESSION = "confluent.controlcenter.rest.compression.enable";
    public static final String DEFAULT_CONTROL_CENTER_REST_COMPRESSION = "true";
    protected static final String CONTROL_CENTER_REST_COMPRESSION_DOC = "Enable HTTP compression";
    public static final String CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS = "confluent.controlcenter.auth.session.expiration.ms";
    public static final long DEFAULT_CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(0L);
    protected static final String CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS_DOC = "Timeout in milliseconds after which a user session will have to be re-authenticated with the authentication service (e.g. LDAP). Defaults to 0, which means authentication is done for every request. Increase this value to avoid calling the LDAP service for  each request.";
    public static final String CONTROL_CENTER_HSTS_ENABLE = "confluent.controlcenter.rest.hsts.enable";
    public static final boolean DEFAULT_CONTROL_CENTER_HSTS_ENABLE = true;
    protected static final String CONTROL_CENTER_HSTS_ENABLE_DOC = "Enable HTTP Strict Transport Security.";
    public static final String CONTROL_CENTER_EMAIL_ENABLE = "confluent.controlcenter.mail.enabled";
    public static final boolean DEFAULT_CONTROL_CENTER_EMAIL_ENABLE = false;
    protected static final String CONTROL_CENTER_EMAIL_ENABLE_DOC = "Enable email alerts. If this setting is false you will not be able to add email alert actions in the web user interface.";
    public static final String CONTROL_CENTER_EMAIL_HOST_NAME = "confluent.controlcenter.mail.host.name";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_HOST_NAME = "localhost";
    protected static final String CONTROL_CENTER_EMAIL_HOST_NAME_DOC = "Hostname of outgoing SMTP server.";
    public static final String CONTROL_CENTER_EMAIL_PORT = "confluent.controlcenter.mail.port";
    public static final Integer DEFAULT_CONTROL_CENTER_EMAIL_PORT = 587;
    protected static final String CONTROL_CENTER_EMAIL_PORT_DOC = "SMTP port open on confluent.controlcenter.mail.host.name";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE = "confluent.controlcenter.alert.cluster.down.autocreate";
    public static final boolean DEFAULT_CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE = false;
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE_DOC = "Auto create trigger and email action for Control Center's cluster down alerts";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL = "confluent.controlcenter.alert.cluster.down.to.email";
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL_DOC = "The email address to send alerts to when Control Center's cluster is down";
    public static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE = "confluent.controlcenter.alert.cluster.down.send.rate";
    public static final Integer DEFAULT_CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE = 12;
    protected static final String CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE_DOC = "Send rate per hour of cluster down email alerts";
    public static final String CONTROL_CENTER_EMAIL_FROM = "confluent.controlcenter.mail.from";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_FROM = "c3@confluent.io";
    protected static final String CONTROL_CENTER_EMAIL_FROM_DOC = "The 'from' address for emails sent from Control Center.";
    public static final String CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS = "confluent.controlcenter.mail.bounce.address";
    protected static final String CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS_DOC = "Override for confluent.controlcenter.mail.from config to send message bounce notifications.";
    public static final String CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY = "confluent.controlcenter.mail.ssl.checkserveridentity";
    public static final Boolean DEFAULT_CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY = false;
    protected static final String CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY_DOC = "Forces validation of server's certificate when using STARTTLS or SSL.";
    public static final String CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED = "confluent.controlcenter.mail.starttls.required";
    public static final Boolean DEFAULT_CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED = false;
    protected static final String CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED_DOC = "Forces using STARTTLS.";
    public static final String CONTROL_CENTER_EMAIL_USERNAME = "confluent.controlcenter.mail.username";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_USERNAME = "";
    protected static final String CONTROL_CENTER_EMAIL_USERNAME_DOC = "Username for username/password authentication. Authentication with your SMTP server will only be performed if this value is set.";
    public static final String CONTROL_CENTER_EMAIL_PASSWORD = "confluent.controlcenter.mail.password";
    public static final String DEFAULT_CONTROL_CENTER_EMAIL_PASSWORD = "";
    protected static final String CONTROL_CENTER_EMAIL_PASSWORD_DOC = "Password for username/password authentication.";
    public static final String CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_CONFIG = "confluent.controlcenter.disk.skew.warning.min.bytes";
    public static final long DEFAULT_CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES = 0x40000000L;
    protected static final String CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_DOC = "Minimum bytes of disk usage skew across all brokers before warning";
    public static final String CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_CONFIG = "confluent.controlcenter.alert.max.trigger.events";
    public static final int DEFAULT_CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_CONFIG = 1000;
    protected static final String CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_DOC = "The maximum number of trigger events in one alert";
    public static final String CONTROL_CENTER_COMMAND_TOPIC = "confluent.controlcenter.command.topic";
    public static final String DEFAULT_CONTROL_CENTER_COMMAND_TOPIC = "_confluent-command";
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_DOC = "Topic used for CP configuration";
    public static final String CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_CONFIG = "confluent.controlcenter.command.topic.replication";
    public static final int DEFAULT_CONTROL_CENTER_COMMAND_TOPIC_REPLICATION = 3;
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_DOC = "Replication factor for command topic. It is not recommended to reduce this value except in a development environment.";
    public static final String CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_CONFIG = "confluent.controlcenter.command.topic.retention.ms";
    public static final int DEFAULT_CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS = 259200000;
    protected static final String CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_DOC = "Retention ms for command topic tombstone entries";
    public static final String CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT = "confluent.controlcenter.command.streams.start.timeout";
    public static final long DEFAULT_CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    protected static final String CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT_DOC = "Timeout when starting command streams in ms";
    public static final String RESTRICTED_ROLES_CONFIG = "confluent.controlcenter.auth.restricted.roles";
    public static final String PHONEHOME_ENABLED = "confluent.support.metrics.enable";
    public static final String PHONEHOME_CUSTOMER_ID = "confluent.support.metrics.customer.id";
    private static final ConfigDef config;
    public static final String ZOOKEEPER_CONNECT_CONFIG = "zookeeper.connect";
    private static final String ZOOKEEPER_CONNECT_DOC = "Specifies the ZooKeeper connection string in the form ``hostname:port`` where host and port are the host and port of a ZooKeeper server. To allow connecting through other ZooKeeper nodes when that ZooKeeper machine is down you can also specify multiple hosts in the form ``hostname1:port1,hostname2:port2,hostname3:port3``.\n\nThe server may also have a ZooKeeper chroot path as part of it's ZooKeeper connection string which puts its data under some path in the global ZooKeeper namespace. If so the consumer should use the same chroot path in its connection string. For example to give a chroot path of /chroot/path you would give the connection string as ``hostname1:port1,hostname2:port2,hostname3:port3/chroot/path``.";
    public static final String ZOOKEEPER_CONNECT_DEFAULT = "localhost:2181";
    @Deprecated
    public static final String KSQL_ENDPOINTS_CONFIG = "confluent.controlcenter.ksql.url";
    @Deprecated
    public static final String KSQL_ADVERTISED_ENDPOINTS_CONFIG = "confluent.controlcenter.ksql.advertised.url";
    public static final String CONFLUENT_CONTROLCENTER_SCHEMA_REGISTRY_PREFIX = "confluent.controlcenter.schema.registry.";
    public static final String SCHEMA_REGISTRY_ENDPOINT_CONFIG = "confluent.controlcenter.schema.registry.url";
    public static final String TOPIC_INSPECTION_ENABLED = "confluent.controlcenter.topic.inspection.enable";
    public static final String KSQL_ENABLED = "confluent.controlcenter.ksql.enable";
    public static final String SCHEMA_REGISTRY_ENABLED = "confluent.controlcenter.schema.registry.enable";
    public static final String BROKER_CONFIGS_EDIT_ENABLED = "confluent.controlcenter.broker.config.edit.enable";
    public static final String CONTROL_CENTER_LICENSE_MANAGER_CONFIG = "confluent.controlcenter.license.manager";
    public static final String DEFAULT_CONTROL_CENTER_LICENSE_MANAGER;
    protected static final String CONTROL_CENTER_LICENSE_MANAGER_DOC = "Control Center License Manager. Client id for Command topic configuration.";
    public static final String LICENSE_MANAGER_ENABLED = "confluent.controlcenter.license.manager.enable";
    protected static final String LICENSE_MANAGER_ENABLED_DOC = "Enable License Manager. (By disabling license manager, you have no access to license editor, notification and license string in rest endpoint.)";
    public static final Boolean DEFAULT_LICENSE_MANAGER_ENABLED;

    public ControlCenterConfig(String propsFile) {
        this(ControlCenterConfig.getPropsFromFile((String)propsFile));
    }

    public ControlCenterConfig(Properties props) {
        super(config, (Map)ConfigUtils.translateDeprecated((Properties)props, (String[][])new String[][]{{CONTROL_CENTER_LICENSE_CONFIG, "confluent.controlcenter.license"}, {CONTROL_CENTER_CONNECT_TIMEOUT_MS, CONTROL_CENTER_CONNECT_TIMEOUT}, {"confluent.controlcenter.schema.registry.basic.auth.user.info", "confluent.controlcenter.schema.registry.schema.registry.basic.auth.user.info"}}));
    }

    public ControlCenterConfig() {
        this(new Properties());
    }

    public static void main(String[] args) {
        System.out.println(config.toRst());
    }

    static {
        DEFAULT_CONTROL_CENTER_LICENSE_MANAGER = "_confluent-controlcenter-license-manager" + "-" + C3Version.getVersion().getMajorVersion() + "-" + C3Version.getVersion().getMinorVersion() + "-" + C3Version.getVersion().getPatchVersion();
        DEFAULT_LICENSE_MANAGER_ENABLED = true;
        config = new ConfigDef().define(CONTROL_CENTER_NAME_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_NAME, ConfigDef.Importance.HIGH, CONTROL_CENTER_NAME_DOC).define(CONTROL_CENTER_ID_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_ID, ConfigDef.Importance.HIGH, CONTROL_CENTER_ID_DOC).define(CONTROL_CENTER_PARALLELISM, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_PARALLELISM, ConfigDef.Importance.HIGH, CONTROL_CENTER_PARALLELISM_DOC).define(CONTROL_CENTER_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_TOPIC, ConfigDef.Importance.HIGH, CONTROL_CENTER_TOPIC_DOC).define(CONTROL_CENTER_METRICS_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_METRICS_TOPIC, ConfigDef.Importance.HIGH, CONTROL_CENTER_METRICS_TOPIC_DOC).define(CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT, ConfigDef.Importance.HIGH, CONTROL_CENTER_INTERNAL_STREAMS_START_TIMEOUT_DOC).define(ZOOKEEPER_CONNECT_CONFIG, ConfigDef.Type.STRING, (Object)ZOOKEEPER_CONNECT_DEFAULT, ConfigDef.Importance.HIGH, ZOOKEEPER_CONNECT_DOC).define(CONTROL_CENTER_LICENSE_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, CONTROL_CENTER_LICENSE_DOC).define(CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, (Object)DEFAULT_CONTROL_CENTER_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Importance.HIGH, CONTROL_CENTER_BOOTSTRAP_SERVERS_DOC).define(CONTROL_CENTER_DATA_DIR, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_DATA_DIR, (ConfigDef.Validator)new WarningValidator(new StringNotPrefixValidator("/tmp", "Running with data in /tmp is not suggested."), log), ConfigDef.Importance.HIGH, CONTROL_CENTER_DATA_DIR_DOC).define(CONTROL_CENTER_INTERNAL_REPLICATION_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)new WarningValidator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)3), log), ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_REPLICATION_DOC).define(CONTROL_CENTER_INTERNAL_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)4, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_PARTITIONS_DOC).define(CONTROL_CENTER_INTERNAL_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INTERNAL_RETENTION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_RETENTION_MS_DOC).define(CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)0x8000000, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_CHANGELOG_SEGMENT_BYTES_DOC).define(CONTROL_CENTER_INTERNAL_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.LOW, CONTROL_CENTER_INTERNAL_RETENTION_BYTES_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_PARTITIONS_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_REPLICATION_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_RETENTION_MS_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_RETENTION_BYTES_DOC).define(CONTROL_CENTER_MONITORING_TOPIC_SKIP_BACKLOG_MIN_CONFIG, ConfigDef.Type.LONG, (Object)15L, ConfigDef.Importance.LOW, "Start processing backlog from minutes ago and skip older data").define(CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_MONITORING_TOPIC_VALIDATE_DOC).define(CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_CONFIG, ConfigDef.Type.INT, (Object)12, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_PARTITIONS_DOC).define(CONTROL_CENTER_METRICS_TOPIC_REPLICATION_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_REPLICATION_DOC).define(CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_INPUT_TOPIC_RETENTION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_RETENTION_MS_DOC).define(CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)-1, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_RETENTION_BYTES_DOC).define(CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_CONFIG, ConfigDef.Type.INT, (Object)0xA00000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_MAX_MESSAGE_BYTES_DOC).define(CONTROL_CENTER_METRICS_TOPIC_SKIP_BACKLOG_MIN_CONFIG, ConfigDef.Type.LONG, (Object)15L, ConfigDef.Importance.LOW, "Start processing backlog from minutes ago and skip older data").define(CONTROL_CENTER_METRICS_TOPIC_VALIDATE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_METRICS_TOPIC_VALIDATE_DOC).define(CONTROL_CENTER_CONNECT_CLUSTER, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, CONTROL_CENTER_CONNECT_CLUSTER_DOC).define(CONTROL_CENTER_CONNECT_TIMEOUT_MS, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_CONNECT_TIMEOUT_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_CONNECT_TIMEOUT_MS_DOC).define(CONTROL_CENTER_SESSION_TIMEOUT_MS_CONFIG, ConfigDef.Type.INT, (Object)60000, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_SESSION_TIMEOUT_MS_DOC).define(CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG, ConfigDef.Type.LONG, (Object)0x40000000L, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_CACHE_MAX_BYTES_BUFFERING_CONFIG_DOC).define(CONTROL_CENTER_STREAMS_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_RETRIES_DOC).define(CONTROL_CENTER_PRODUCER_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_PRODUCER_RETRIES_DOC).define(CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_CONFIG, ConfigDef.Type.LONG, (Object)100L, ConfigDef.Importance.MEDIUM, CONTROL_CENTER_PRODUCER_RETRY_BACKOFF_MS_DOC).define(CONTROL_CENTER_COMPRESSION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_COMPRESSION_TYPE_CONFIG, ConfigDef.Importance.LOW, CONTROL_CENTER_COMPRESSION_TYPE_DOC).define(CONTROL_CENTER_PRODUCER_LINGER_MS, ConfigDef.Type.INT, (Object)500, ConfigDef.Importance.LOW, CONTROL_CENTER_PRODUCER_LINGER_MS_DOC).define(CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, ConfigDef.Importance.LOW, CONTROL_CENTER_PRODUCER_MAX_BLOCK_MS_DOC).define(CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS, ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, ConfigDef.Importance.LOW, CONTROL_CENTER_PRODUCER_DELIVERY_TIMEOUT_MS_DOC).define(CONTROL_CENTER_REST_PORT, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_REST_PORT, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_PORT_DOC).define(CONTROL_CENTER_REST_COMPRESSION, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_REST_COMPRESSION, ConfigDef.Importance.LOW, CONTROL_CENTER_REST_COMPRESSION_DOC).define(CONTROL_CENTER_HSTS_ENABLE, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, CONTROL_CENTER_HSTS_ENABLE_DOC).define(CONTROL_CENTER_DISPLAY_HOST_PREFIX, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_DISPLAY_HOST_PREFIX_DOC).define(CONTROL_CENTER_EMAIL_ENABLE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_ENABLE_DOC).define(CONTROL_CENTER_EMAIL_HOST_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_EMAIL_HOST_NAME, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_HOST_NAME_DOC).define(CONTROL_CENTER_EMAIL_PORT, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_EMAIL_PORT, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_PORT_DOC).define(CONTROL_CENTER_EMAIL_FROM, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_EMAIL_FROM, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_FROM_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_AUTOCREATE_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_TO_EMAIL_DOC).define(CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE, ConfigDef.Type.INT, (Object)DEFAULT_CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE, ConfigDef.Importance.LOW, CONTROL_CENTER_ALERT_CLUSTER_DOWN_SEND_RATE_DOC).define(CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_BOUNCE_ADDRESS_DOC).define(CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_SSL_CHECKSERVERIDENTITY_DOC).define(CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED, ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_STARTTLS_REQUIRED_DOC).define(CONTROL_CENTER_EMAIL_USERNAME, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_USERNAME_DOC).define(CONTROL_CENTER_EMAIL_PASSWORD, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, CONTROL_CENTER_EMAIL_PASSWORD_DOC).define(CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_CONFIG, ConfigDef.Type.LONG, (Object)0x40000000L, ConfigDef.Importance.LOW, CONTROL_CENTER_DISK_USAGE_SKEW_WARNING_MIN_BYTES_DOC).define(CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, CONTROL_CENTER_MAX_TRIGGER_EVENTS_PER_ALERT_DOC).define(CONTROL_CENTER_COMMAND_TOPIC, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_COMMAND_TOPIC, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_DOC).define(CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_REPLICATION_DOC).define(CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_CONFIG, ConfigDef.Type.LONG, (Object)259200000, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_TOPIC_RETENTION_MS_DOC).define(CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT, ConfigDef.Importance.LOW, CONTROL_CENTER_COMMAND_STREAMS_START_TIMEOUT_DOC).define(CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS, ConfigDef.Type.LONG, (Object)DEFAULT_CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS, ConfigDef.Importance.LOW, CONTROL_CENTER_AUTH_SESSION_EXPIRATION_MS_DOC).define(RESTRICTED_ROLES_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, "List of roles with limited access. No editing or creating via UI").define(PHONEHOME_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Confluent metrics collection").define(PHONEHOME_CUSTOMER_ID, ConfigDef.Type.STRING, (Object)"anonymous", ConfigDef.Importance.LOW, "Confluent metrics customer id").define(KSQL_ENDPOINTS_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "(Deprecated) Ksql Endpoints").define(KSQL_ADVERTISED_ENDPOINTS_CONFIG, ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "(Deprecated) Ksql Endpoints advertised externally through the rest api").define(SCHEMA_REGISTRY_ENDPOINT_CONFIG, ConfigDef.Type.LIST, (Object)"http://localhost:8081", ConfigDef.Importance.LOW, "Schema Registry Endpoint").define(TOPIC_INSPECTION_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Topic Inspection in Control Center").define(KSQL_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable KSQL in Control Center").define(SCHEMA_REGISTRY_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Schema Registry in Control Center").define(BROKER_CONFIGS_EDIT_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, "Enable Broker config edit").define(LICENSE_MANAGER_ENABLED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_LICENSE_MANAGER_ENABLED, ConfigDef.Importance.LOW, LICENSE_MANAGER_ENABLED_DOC).define(CONTROL_CENTER_LICENSE_MANAGER_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_CONTROL_CENTER_LICENSE_MANAGER, ConfigDef.Importance.LOW, CONTROL_CENTER_LICENSE_MANAGER_DOC);
    }
}

