/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import java.util.concurrent.TimeUnit;

public enum Rollup {
    ONE_MINUTE(TimeUnit.MINUTES.toMillis(1L), TimeUnit.DAYS.toMillis(4L)),
    THREE_HOURS(TimeUnit.HOURS.toMillis(3L), TimeUnit.DAYS.toMillis(700L));

    private final long millis;
    private final long retainMillis;

    private Rollup(long millis, long retainMillis) {
        this.millis = millis;
        this.retainMillis = retainMillis;
    }

    public long getMillis() {
        return this.millis;
    }

    public long getRetainMillis() {
        return this.retainMillis;
    }

    public long getRetainSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(this.retainMillis);
    }

    public long toWindow(long unalignedWindow) {
        return Rollup.window(this.millis, unalignedWindow);
    }

    public static long window(long rollup, long unalignedWindow) {
        return unalignedWindow - unalignedWindow % rollup;
    }
}

