/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticClusterConfigSupplier {
    private static final Logger log = LoggerFactory.getLogger(StaticClusterConfigSupplier.class);
    private final String configPrefix;
    private final ControlCenterConfig config;

    @Inject
    public StaticClusterConfigSupplier(ControlCenterConfig config, String configPrefix) {
        this.config = config;
        this.configPrefix = configPrefix;
    }

    public Map<String, Map<String, Object>> getConfigurations() {
        LinkedHashMap clusters = Maps.newLinkedHashMap();
        LinkedHashMap clusterConfigs = Maps.newLinkedHashMap();
        clusterConfigs.putAll(this.config.originalsWithPrefix(this.configPrefix));
        clusterConfigs.putAll(this.config.valuesWithPrefix(this.configPrefix));
        for (Map.Entry entry : clusterConfigs.entrySet()) {
            String key = (String)entry.getKey();
            int nameLength = key.indexOf(".");
            if (nameLength <= 0) continue;
            String clusterName = key.substring(0, nameLength);
            String property = key.substring(nameLength + 1);
            Map clientConfig = (Map)clusters.get(clusterName);
            if (clientConfig == null) {
                log.debug("Reading static configuration for cluster {}", (Object)clusterName);
                clientConfig = Maps.newHashMap();
                clusters.put(clusterName, clientConfig);
            }
            clientConfig.put(property, entry.getValue());
        }
        return clusters;
    }
}

