/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.protobuf.Descriptors;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.alert.EmailProvider;
import io.confluent.controlcenter.alert.record.Alert;
import java.util.Arrays;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger log = LoggerFactory.getLogger(EmailSender.class);
    private static final Descriptors.FieldDescriptor EMAIL_FIELD = Alert.ActionInfo.getDescriptor().findFieldByNumber(3);
    private final EmailProvider<Email> emailProvider;
    private final ControlCenterConfig config;
    private final String restEndpoint;

    public EmailSender(EmailProvider<Email> emailProvider, ControlCenterConfig config, String restEndpoint) {
        this.emailProvider = emailProvider;
        this.config = config;
        this.restEndpoint = restEndpoint;
    }

    public void sendWithHistory(Alert.AlertInfo info) {
        this.send(info, true);
    }

    public void sendWithoutHistory(Alert.AlertInfo info) {
        this.send(info, false);
    }

    private void send(Alert.AlertInfo info, boolean linkToHistory) {
        for (Alert.ActionInfo ai : info.getActionsList()) {
            if (!ai.hasField(EMAIL_FIELD)) continue;
            CommandAlert.EmailAction emailAction = ai.getEmail();
            if (this.config.getBoolean("confluent.controlcenter.mail.enabled")) {
                try {
                    Email email = this.emailProvider.get();
                    String emailAddresses = emailAction.getAddress();
                    email.setTo(Arrays.asList(InternetAddress.parse((String)emailAddresses)));
                    email.setSubject(emailAction.getSubject());
                    if (linkToHistory) {
                        email.setMsg(String.format("%s/alerts/overview/history/%d-%s", this.restEndpoint, info.getTimestamp(), info.getGuid()));
                    }
                    String messageId = email.send();
                    log.debug("sending=success email to={} with subject={} from trigger={} messageId={}", new Object[]{emailAction.getAddress(), emailAction.getSubject(), info.getMonitoringTrigger().getGuid(), messageId});
                }
                catch (AddressException | EmailException e) {
                    log.warn("sending=failure email to={} with subject={} from trigger={} {}", new Object[]{emailAction.getAddress(), emailAction.getSubject(), info.getMonitoringTrigger().getGuid(), e});
                }
                continue;
            }
            log.debug("sending=prevented email to={} with subject={} from trigger={} messageId={}", new Object[]{emailAction.getAddress(), emailAction.getSubject(), info.getMonitoringTrigger().getGuid()});
        }
    }
}

