/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.alert;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.throwingproviders.CheckedProvides;
import com.google.inject.throwingproviders.ThrowingProviderBinder;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.alert.EmailProvider;
import io.confluent.controlcenter.alert.EmailSender;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(SenderModule.class);

    protected void configure() {
        this.install(ThrowingProviderBinder.forModule((Module)this));
    }

    @CheckedProvides(value=EmailProvider.class)
    @Inject
    protected Email provideBaseEmail(ControlCenterConfig config) throws EmailException {
        String username;
        SimpleEmail email = new SimpleEmail();
        email.setHostName(config.getString("confluent.controlcenter.mail.host.name"));
        email.setSmtpPort(config.getInt("confluent.controlcenter.mail.port"));
        email.setSSLOnConnect(config.getBoolean("confluent.controlcenter.mail.ssl.checkserveridentity"));
        email.setStartTLSRequired(config.getBoolean("confluent.controlcenter.mail.starttls.required"));
        email.setFrom(config.getString("confluent.controlcenter.mail.from"));
        String bounceAddress = config.getString("confluent.controlcenter.mail.bounce.address");
        if (!Strings.isNullOrEmpty((String)bounceAddress)) {
            email.setBounceAddress(bounceAddress);
        }
        if (!Strings.isNullOrEmpty((String)(username = config.getString("confluent.controlcenter.mail.username")))) {
            email.setAuthentication(username, config.getString("confluent.controlcenter.mail.password"));
        }
        return email;
    }

    @Provides
    @Inject
    protected EmailSender provideEmailSender(EmailProvider<Email> emailProvider, ControlCenterConfig config, @ControlCenterRestModule.RestEndpoint String restEndpoint) {
        return new EmailSender(emailProvider, config, restEndpoint);
    }
}

