/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.command;

import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.command.CommandStore;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.command.CommandKeyTypePredicate;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.util.FilteredReadOnlyKeyValueStore;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(CommandModule.class);

    protected void configure() {
    }

    @Provides
    @Inject
    @CommandStateDir
    protected Path getCommandStateDir(ControlCenterConfig controlCenterConfig) throws IOException {
        Path commandStateDir = Paths.get(controlCenterConfig.getString("confluent.controlcenter.data.dir"), controlCenterConfig.getString("confluent.controlcenter.id"), "cp-command");
        Files.createParentDirs((File)commandStateDir.toFile());
        return commandStateDir;
    }

    @Provides
    @Singleton
    protected CommandStore provideCommandStore(ControlCenterConfig controlCenterConfig, @CommandStateDir Path commandStateDir) throws TimeoutException, InterruptedException {
        Properties props = new Properties();
        props.put("bootstrap.servers", controlCenterConfig.getList("bootstrap.servers"));
        props.put("state.dir", commandStateDir.toString());
        String streamsAppId = TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.name"), controlCenterConfig.getString("confluent.controlcenter.id"), "command");
        props.put("application.id", streamsAppId);
        props.put(StreamsConfig.producerPrefix((String)"max.request.size"), (Object)0xA00000);
        props.putAll((Map<?, ?>)controlCenterConfig.valuesWithPrefix("confluent.controlcenter.streams."));
        props.putAll((Map<?, ?>)controlCenterConfig.originalsWithPrefix("confluent.controlcenter.streams."));
        props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        props.put(StreamsConfig.producerPrefix((String)"acks"), "all");
        props.put("num.stream.threads", "1");
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("topology.optimization", "all");
        StreamsConfig streamsConfig = new StreamsConfig((Map)props);
        CommandStore commander = new CommandStore.Builder().topic(controlCenterConfig.getString("confluent.controlcenter.command.topic")).streamsConfig(streamsConfig).producerConfig(streamsConfig.getProducerConfigs("c3-command")).build();
        return commander;
    }

    @Provides
    @Inject
    @Singleton
    @TriggerConfigs
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideTriggerConfigs(CommandStore commandStore) {
        return new FilteredReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>(commandStore.getStore(), CommandKeyTypePredicate.MONITORING_TRIGGER_CONFIG);
    }

    @Provides
    @Inject
    @Singleton
    @ActionConfigs
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideActionConfigs(CommandStore commandStore) {
        return new FilteredReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>(commandStore.getStore(), CommandKeyTypePredicate.ACTION_CONFIG);
    }

    @Provides
    @Inject
    @Singleton
    @ClusterMetadataStore
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideClusterMetadata(CommandStore commandStore) {
        return new FilteredReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>(commandStore.getStore(), CommandKeyTypePredicate.CLUSTER_METADATA);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ClusterMetadataStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ActionConfigs {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerConfigs {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface CommandStateDir {
    }
}

