/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.connect;

import io.confluent.controlcenter.connect.ConnectService;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectClusterController {
    private static final Logger log = LoggerFactory.getLogger(ConnectClusterController.class);
    private String kafkaClusterId = null;
    private final String clusterId;
    private final String displayName;
    private final List<String> urls;
    private final long timeoutMs;
    private ConnectService connectService = null;

    public ConnectClusterController(String displayName, List<String> urls, long timeoutMs) {
        this.displayName = displayName;
        this.urls = urls;
        this.timeoutMs = timeoutMs;
        this.clusterId = displayName;
    }

    public ConnectService getConnectService() {
        if (this.connectService == null) {
            this.connectService = new ConnectService(this.clusterId, this.urls, this.timeoutMs);
        }
        return this.connectService;
    }

    public Runnable makeInitializer() {
        return new ConnectPollInit(this);
    }

    public ConnectCluster toRestObject() {
        return new ConnectCluster(this.urls, this.clusterId, this.kafkaClusterId, this.displayName);
    }

    public boolean isInitialized() {
        return this.kafkaClusterId != null;
    }

    protected void setKafkaClusterId(String kafkaClusterId) {
        this.kafkaClusterId = kafkaClusterId;
    }

    public static class ConnectPollInit
    implements Runnable {
        private static final long INITIAL_POLLING_DELAY = 15000L;
        private static final long MAX_POLLING_DELAY = 180000L;
        private final ConnectClusterController controller;

        public ConnectPollInit(ConnectClusterController controller) {
            this.controller = controller;
        }

        @Override
        public void run() {
            long pollingDelay = 15000L;
            while (!this.controller.isInitialized()) {
                try {
                    ConnectService connectService = this.controller.getConnectService();
                    ConnectService.ConnectKafkaCluster clusterInfo = connectService.getConnectKafkaCluster();
                    this.controller.setKafkaClusterId(clusterInfo.kafkaClusterId);
                    connectService.getConnectorPlugins();
                    connectService.getConnectors();
                    return;
                }
                catch (Throwable t) {
                    log.warn("failed to connect to kafka-connect {}", (Object)t.getMessage());
                    try {
                        Thread.sleep(pollingDelay);
                        pollingDelay = Math.min(pollingDelay * 2L, 180000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }
}

