/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.connect;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import io.confluent.controlcenter.connect.ConnectorStatus;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import io.confluent.controlcenter.util.UriUtils;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorPluginInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.rest.entities.CreateConnectorRequest;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectService {
    private static final Logger log = LoggerFactory.getLogger(ConnectService.class);
    private final String clusterId;
    private final Supplier<WebTarget> connect;
    private final List<WebTarget> connectTargets;
    private final long timeout;

    public ConnectService(String clusterId, List<String> urls, long timeout) {
        this.clusterId = clusterId;
        this.timeout = timeout;
        final Client client = ClientBuilder.newClient();
        this.connectTargets = FluentIterable.from(urls).transform((Function)new Function<String, WebTarget>(){

            public WebTarget apply(String url) {
                try {
                    return client.target(UriUtils.uriWithDefaultScheme(url, "http"));
                }
                catch (URISyntaxException e) {
                    log.error("Unable to parse Kafka Connect URI", (Throwable)e);
                    return null;
                }
            }
        }).filter(Predicates.notNull()).toList();
        if (this.connectTargets.isEmpty()) {
            log.warn("confluent.controlcenter.connect.cluster configuration is empty.");
            this.connect = null;
            return;
        }
        final Random random = new Random();
        this.connect = new Supplier<WebTarget>(){

            public WebTarget get() {
                return (WebTarget)ConnectService.this.connectTargets.get(random.nextInt(ConnectService.this.connectTargets.size()));
            }
        };
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public List<BackwardsCompatibleConnectorPluginInfo> getConnectorPlugins() throws InterruptedException, ExecutionException, TimeoutException {
        return (List)new BaseTargetAndConnectors().invoke().getBaseTarget().path("connector-plugins").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get((GenericType)new GenericType<List<BackwardsCompatibleConnectorPluginInfo>>(){}).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Response validateConnectorPlugin(String connType, Map<String, String> connectorConfig) throws InterruptedException, ExecutionException, TimeoutException {
        return (Response)new BaseTargetAndConnectors().invoke().getBaseTarget().path("connector-plugins").path(connType).path("config").path("validate").request().async().put(Entity.entity(connectorConfig, (MediaType)MediaType.APPLICATION_JSON_TYPE)).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public List<Connector> getConnectors() throws InterruptedException, ExecutionException, TimeoutException {
        BaseTargetAndConnectors baseTargetAndConnectors = new BaseTargetAndConnectors().invoke();
        List<String> connectors = baseTargetAndConnectors.getConnectors();
        final WebTarget baseTarget = baseTargetAndConnectors.getBaseTarget();
        List results = Lists.transform(connectors, (Function)new Function<String, ListenableFuture<Connector>>(){

            public ListenableFuture<Connector> apply(final String connector) {
                ListenableFuture infoFuture = JdkFutureAdapters.listenInPoolThread((Future)baseTarget.path("connectors").path(connector).request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get((GenericType)new GenericType<ConnectorInfo>(){}));
                ConnectService.logFutureFailure("Failed to request connector information", infoFuture);
                return Futures.transformAsync((ListenableFuture)infoFuture, (AsyncFunction)new AsyncFunction<ConnectorInfo, Connector>(){

                    public ListenableFuture<Connector> apply(final ConnectorInfo connectorInfo) {
                        ListenableFuture statusFuture = JdkFutureAdapters.listenInPoolThread((Future)baseTarget.path("connectors").path(connector).path("status").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get((GenericType)new GenericType<ConnectorStatus>(){}));
                        ConnectService.logFutureFailure("Failed to request connector status", statusFuture);
                        return Futures.transform((ListenableFuture)statusFuture, (Function)new Function<ConnectorStatus, Connector>(){

                            public Connector apply(ConnectorStatus connectorStatus) {
                                return new Connector(connectorInfo, connectorStatus);
                            }
                        });
                    }
                });
            }
        });
        return (List)Futures.successfulAsList((Iterable)results).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    private static <T> void logFutureFailure(final String message, ListenableFuture<T> infoFuture) {
        Futures.addCallback(infoFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
            }

            public void onFailure(Throwable t) {
                log.error(message, t);
            }
        });
    }

    public ConnectKafkaCluster getConnectKafkaCluster() throws InterruptedException, ExecutionException, TimeoutException {
        return (ConnectKafkaCluster)new BaseTargetAndConnectors().invoke().getBaseTarget().request().async().get((GenericType)new GenericType<ConnectKafkaCluster>(){}).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object createConnector(CreateConnectorRequest createRequest) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").request().async().post(Entity.entity((Object)createRequest, (MediaType)MediaType.APPLICATION_JSON_TYPE)).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public BackwardsCompatibleConnectorInfo getConnector(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return (BackwardsCompatibleConnectorInfo)((Object)new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).request().get((GenericType)new GenericType<BackwardsCompatibleConnectorInfo>(){}));
    }

    public Object getConnectorStatus(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("status").request().async().get().get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object getTaskConfigs(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("tasks").request().async().get().get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object getConnectorConfig(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("config").request().async().get().get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object putConnectorConfig(String connector, Map<String, String> connectorConfig) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("config").request().async().put(Entity.entity(connectorConfig, (MediaType)MediaType.APPLICATION_JSON_TYPE)).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object putConnectorPause(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("pause").request().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).async().put(null).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object putConnectorResume(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("resume").request().property("jersey.config.client.suppressHttpComplianceValidation", (Object)true).async().put(null).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object putTaskConfigs(String connector, List<Map<String, String>> taskConfigs) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("tasks").request().async().put(Entity.entity(taskConfigs, (MediaType)MediaType.APPLICATION_JSON_TYPE)).get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object getTaskStatus(String connector, Integer task) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).path("tasks").path(task.toString()).request().async().get().get(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Object destroyConnector(String connector) throws InterruptedException, ExecutionException, TimeoutException {
        return new BaseTargetAndConnectors().invoke().getBaseTarget().path("connectors").path(connector).request().async().delete().get(this.timeout, TimeUnit.MILLISECONDS);
    }

    private class BaseTargetAndConnectors {
        private WebTarget baseTarget;
        private List<String> connectors;

        private BaseTargetAndConnectors() {
        }

        public WebTarget getBaseTarget() {
            return this.baseTarget;
        }

        public BaseTargetAndConnectors invoke() throws InterruptedException, TimeoutException, ExecutionException {
            this.baseTarget = null;
            this.connectors = null;
            int retries = 3;
            while (this.connectors == null && retries-- > 0) {
                try {
                    WebTarget newbaseTarget = this.baseTarget;
                    int baseRetries = 3;
                    while (newbaseTarget == this.baseTarget && baseRetries-- > 0) {
                        newbaseTarget = (WebTarget)ConnectService.this.connect.get();
                    }
                    this.baseTarget = newbaseTarget;
                    this.connectors = this.getConnectors(this.baseTarget);
                }
                catch (ExecutionException ee) {
                    log.warn("problem getting connectors", (Object)ee.getMessage());
                    if (retries <= 0) {
                        throw ee;
                    }
                    Thread.sleep(50L);
                }
            }
            return this;
        }

        public List<String> getConnectors() {
            return this.connectors;
        }

        private List<String> getConnectors(WebTarget baseTarget) throws InterruptedException, ExecutionException, TimeoutException {
            return (List)baseTarget.path("connectors").request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).async().get((GenericType)new GenericType<List<String>>(){}).get(ConnectService.this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    @JsonStandard
    public static class BackwardsCompatibleConnectorInfo
    extends ConnectorInfo {
        @JsonCreator
        public BackwardsCompatibleConnectorInfo(@JsonProperty(value="name") String name, @JsonProperty(value="config") Map<String, String> config, @JsonProperty(value="tasks") List<ConnectorTaskId> tasks, @JsonProperty(value="type") ConnectorType type) {
            super(name, config, tasks, type == null ? C3ConnectorType.fromString(config.get("connector.class")).toConnectorType() : type);
        }
    }

    @JsonStandard
    public static class Connector {
        public String name;
        public ConnectorType type;
        public int tasks;
        public String status;
        @JsonStandard
        public String topics;

        public Connector() {
        }

        public Connector(ConnectorInfo connectorInfo, ConnectorStatus connectorStatus) {
            this.name = connectorInfo.name();
            this.type = connectorStatus.type == null ? C3ConnectorType.fromString((String)connectorInfo.config().get("connector.class")).toConnectorType() : connectorStatus.type;
            this.tasks = connectorInfo.tasks().size();
            this.topics = (String)connectorInfo.config().get("topics");
            this.status = connectorStatus.connector.state;
        }
    }

    @JsonStandard
    public static class BackwardsCompatibleConnectorPluginInfo
    extends ConnectorPluginInfo {
        @JsonCreator
        public BackwardsCompatibleConnectorPluginInfo(@JsonProperty(value="class") String className, @JsonProperty(value="type") ConnectorType type, @JsonProperty(value="version") String version) {
            super(className, type == null ? C3ConnectorType.fromString(className).toConnectorType() : type, version);
        }

        public BackwardsCompatibleConnectorPluginInfo(PluginDesc<org.apache.kafka.connect.connector.Connector> plugin) {
            super(plugin);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConnectKafkaCluster {
        @JsonProperty(value="kafka_cluster_id")
        public String kafkaClusterId;

        @JsonCreator
        public ConnectKafkaCluster(@JsonProperty(value="kafka_cluster_id") String kafkaClusterId) {
            this.kafkaClusterId = kafkaClusterId;
        }
    }

    public static enum C3ConnectorType {
        SOURCE(ConnectorType.SOURCE),
        SINK(ConnectorType.SINK),
        UNKNOWN(ConnectorType.UNKNOWN);

        private ConnectorType type;

        private C3ConnectorType(ConnectorType type) {
            this.type = type;
        }

        public static C3ConnectorType fromString(String s) {
            if (s != null) {
                for (C3ConnectorType type : C3ConnectorType.values()) {
                    if (!s.toLowerCase().contains(type.name().toLowerCase())) continue;
                    return type;
                }
            }
            return UNKNOWN;
        }

        public ConnectorType toConnectorType() {
            return this.type;
        }
    }
}

