/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.inject.Inject;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import java.util.Map;
import java.util.concurrent.Callable;

public class ClusterMetadataInitializer
implements Callable<Void> {
    static final String DEFAULT_CLUSTER_KEY = "controlcenter.cluster";
    private final BootstrapClientConfigSupplier bootstrapClientConfigSupplier;
    private final ClusterManager clusterManager;
    private final StaticClusterConfigSupplier kafkaClusterConfigSupplier;
    private String bootstrapClusterId;

    @Inject
    public ClusterMetadataInitializer(BootstrapClientConfigSupplier bootstrapClientConfigSupplier, @ControlCenterRestModule.KafkaClusterConfigSupplier StaticClusterConfigSupplier kafkaClusterConfigSupplier, ClusterManager clusterManager) {
        this.bootstrapClientConfigSupplier = bootstrapClientConfigSupplier;
        this.clusterManager = clusterManager;
        this.kafkaClusterConfigSupplier = kafkaClusterConfigSupplier;
    }

    @Override
    public Void call() throws Exception {
        this.bootstrapClusterId = this.clusterManager.register(DEFAULT_CLUSTER_KEY, (Map<String, Object>)this.bootstrapClientConfigSupplier.get());
        for (Map.Entry<String, Map<String, Object>> entry : this.kafkaClusterConfigSupplier.getConfigurations().entrySet()) {
            this.clusterManager.addConfiguration(entry.getKey(), entry.getValue());
        }
        return null;
    }

    public String getBootstrapClusterId() {
        return this.bootstrapClusterId;
    }
}

