/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaDao
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KafkaDao.class);
    private static final long DEFAULT_METADATA_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private final AdminClient kafkaAdminClient;
    private final String clusterId;

    public KafkaDao(String clusterId, AdminClient kafkaAdminClient) {
        this.clusterId = clusterId;
        this.kafkaAdminClient = kafkaAdminClient;
    }

    public List<TopicDescription> getTopics(Collection<String> topics, final boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        Collection topicMetadata = Collections2.filter(((Map)this.kafkaAdminClient.describeTopics(topics).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS)).values(), (Predicate)new Predicate<TopicDescription>(){

            public boolean apply(TopicDescription description) {
                return description != null && (!excludeDefaultTopics || !description.isInternal());
            }
        });
        return Ordering.natural().nullsFirst().onResultOf((Function)new Function<TopicDescription, String>(){

            public String apply(TopicDescription input) {
                return input.name();
            }
        }).immutableSortedCopy((Iterable)topicMetadata);
    }

    public List<TopicDescription> getTopics(boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        Collection topics = (Collection)this.kafkaAdminClient.listTopics(new ListTopicsOptions().listInternal(!excludeDefaultTopics)).names().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
        return this.getTopics(topics, excludeDefaultTopics);
    }

    public TopicDescription getTopic(String topic) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getTopics(Collections.singleton(topic), false).get(0);
    }

    public void createTopics(Collection<NewTopic> newTopics, boolean validate) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.createTopics(newTopics, new CreateTopicsOptions().validateOnly(validate)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void deleteTopics(Collection<String> topics) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.deleteTopics(topics).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Map<ConfigResource, Config> getConfigs(Collection<ConfigResource> resources) throws InterruptedException, ExecutionException, TimeoutException {
        return (Map)this.kafkaAdminClient.describeConfigs(resources, new DescribeConfigsOptions().includeSynonyms(true)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void alterConfigs(Map<ConfigResource, Config> configs, boolean validateOnly) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.alterConfigs(configs, new AlterConfigsOptions().validateOnly(validateOnly)).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Collection<AclBinding> getAcls(AclBindingFilter aclFilter) throws InterruptedException, ExecutionException, TimeoutException {
        return (Collection)this.kafkaAdminClient.describeAcls(aclFilter).values().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void createAcls(Collection<AclBinding> aclBindings) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.createAcls(aclBindings).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public void deleteAcls(Collection<AclBindingFilter> aclBindingFilters) throws InterruptedException, ExecutionException, TimeoutException {
        this.kafkaAdminClient.deleteAcls(aclBindingFilters).all().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public Collection<Node> getNodes() throws InterruptedException, ExecutionException, TimeoutException {
        return (Collection)this.kafkaAdminClient.describeCluster().nodes().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public void close() {
        this.kafkaAdminClient.close();
    }
}

