/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.base.Function;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.KafkaDao;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.streams.StreamsModule;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.connect.errors.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetadataDao {
    private static final Logger log = LoggerFactory.getLogger(KafkaMetadataDao.class);
    private static final long DEFAULT_METADATA_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    private final LoadingCache<String, SortedSet<Integer>> brokerCache;
    private final LoadingCache<String, SortedSet<String>> topicCache;
    private final AdminClientSupplier<String> adminClientSupplier;

    @Inject
    public KafkaMetadataDao(@StreamsModule.BrokerCache LoadingCache<String, SortedSet<Integer>> brokerCache, @StreamsModule.TopicCache LoadingCache<String, SortedSet<String>> topicCache, AdminClientSupplier<String> adminClientSupplier) {
        this.brokerCache = brokerCache;
        this.topicCache = topicCache;
        this.adminClientSupplier = adminClientSupplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TopicDescription> getTopics(String clusterId, boolean excludeDefaultTopics) throws InterruptedException, ExecutionException, TimeoutException {
        try (AdminClient kafkaAdminClient = this.adminClientSupplier.getClient(clusterId);){
            KafkaDao dao = new KafkaDao(clusterId, kafkaAdminClient);
            List<TopicDescription> list = dao.getTopics(excludeDefaultTopics);
            return list;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public List<String> getTopicNamesFromMetadataOrCache(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        List<String> topicsFromCache = this.getTopicsFromCache(clusterId);
        try {
            List<TopicDescription> topicMetadata = this.getTopics(clusterId, true);
            if (topicMetadata != null) {
                return Ordering.natural().sortedCopy(Iterables.transform(topicMetadata, (Function)new Function<TopicDescription, String>(){

                    public String apply(TopicDescription input) {
                        return input.name();
                    }
                }));
            }
            if (topicsFromCache != null) {
                return topicsFromCache;
            }
        }
        catch (Exception e) {
            if (topicsFromCache != null) {
                return topicsFromCache;
            }
            throw e;
        }
        throw new NotFoundException("No such cluster: " + clusterId);
    }

    public List<String> getTopicsFromCache(String clusterId) {
        if (!this.topicCache.asMap().containsKey(clusterId)) {
            return null;
        }
        return Lists.newLinkedList((Iterable)((Iterable)this.topicCache.getUnchecked((Object)clusterId)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Node> getNodes(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        try (AdminClient kafkaAdminClient = this.adminClientSupplier.getClient(clusterId);){
            Collection collection = (Collection)kafkaAdminClient.describeCluster().nodes().get(DEFAULT_METADATA_TIMEOUT, TimeUnit.MILLISECONDS);
            return collection;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public List<Integer> getBrokerIdsFromCacheOrMetadata(String clusterId) throws InterruptedException, ExecutionException, TimeoutException {
        List<Integer> brokerIdsFromCache = this.getBrokerIdsFromCache(clusterId);
        if (brokerIdsFromCache == null) {
            Collection<Node> nodes = this.getNodes(clusterId);
            if (nodes != null) {
                List brokerIds = Ordering.natural().sortedCopy(Iterables.transform(nodes, (Function)new Function<Node, Integer>(){

                    public Integer apply(Node input) {
                        return input.id();
                    }
                }));
                ((SortedSet)this.brokerCache.getUnchecked((Object)clusterId)).addAll(brokerIds);
                return brokerIds;
            }
        } else {
            return brokerIdsFromCache;
        }
        throw new NotFoundException("No such cluster: " + clusterId);
    }

    public List<Integer> getBrokerIdsFromCache(String clusterId) {
        if (!this.brokerCache.asMap().containsKey(clusterId)) {
            return null;
        }
        return Lists.newLinkedList((Iterable)((Iterable)this.brokerCache.getUnchecked((Object)clusterId)));
    }
}

