/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.controlcenter.kafka.AdminClientFactory;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.kafka.CachingAdminClientSupplier;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.ClusterView;
import io.confluent.controlcenter.kafka.ConsumerManager;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import io.confluent.controlcenter.kafka.DefaultAdminClientFactory;
import java.util.Map;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;

public class ClusterManagementModule
extends AbstractModule {
    protected void configure() {
        this.bind(AdminClientFactory.class).to(DefaultAdminClientFactory.class).in(Singleton.class);
        this.bind(ClusterView.class).to(ClusterManager.class);
        this.bind(ClusterManager.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    @Inject
    AdminClientSupplier<String> adminClientSupplier(ClusterView clusterView, ClusterManager clusterManager) {
        final CachingAdminClientSupplier<String> cachingAdminClientSupplier = new CachingAdminClientSupplier<String>(clusterManager);
        clusterView.registerClusterCallback(new ClusterView.ClusterCallback(){

            @Override
            public void clusterUpdated(String clusterId) {
                cachingAdminClientSupplier.invalidate(clusterId);
            }

            @Override
            public void clusterAdded(String clusterId) {
            }
        });
        return cachingAdminClientSupplier;
    }

    @Provides
    @Singleton
    @Inject
    ConsumerSupplier<byte[], byte[], String> consumerSupplier(ClusterManager clusterManager) {
        ImmutableMap configs = ImmutableMap.builder().put((Object)"group.id", (Object)"").put((Object)"max.poll.records", (Object)10).put((Object)"key.deserializer", ByteArrayDeserializer.class).put((Object)"value.deserializer", ByteArrayDeserializer.class).build();
        return new ConsumerManager<byte[], byte[]>(clusterManager, (Map<String, Object>)configs);
    }
}

