/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.ConsumerSupplier;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class ConsumerManager<K, V>
implements ConsumerSupplier<K, V, String> {
    private final ClusterManager clusterManager;
    private final Map<String, Object> additionalConsumerConfigs;

    @Inject
    public ConsumerManager(ClusterManager clusterManager, Map<String, Object> additionalConsumerConfigs) {
        this.clusterManager = clusterManager;
        this.additionalConsumerConfigs = additionalConsumerConfigs;
    }

    @Override
    public Consumer<K, V> getConsumer(String clusterId) {
        HashMap configs = Maps.newHashMap(this.clusterManager.getConfigs(clusterId));
        configs.putAll(this.additionalConsumerConfigs);
        ConsumerConfig consumerConfigs = new ConsumerConfig((Map)configs);
        return new KafkaConsumer(consumerConfigs.values());
    }
}

