/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class DelegatingConsumer<K, V>
implements Consumer<K, V> {
    private final Consumer<K, V> delegate;

    public DelegatingConsumer(Consumer<K, V> delegate) {
        this.delegate = delegate;
    }

    public Set<TopicPartition> assignment() {
        return this.delegate.assignment();
    }

    public void assign(Collection<TopicPartition> partitions) {
        this.delegate.assign(partitions);
    }

    public Set<String> subscription() {
        return this.delegate.subscription();
    }

    public void subscribe(Collection<String> topics) {
        this.delegate.subscribe(topics);
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(topics, callback);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener callback) {
        this.delegate.subscribe(pattern, callback);
    }

    public void subscribe(Pattern pattern) {
        this.delegate.subscribe(pattern);
    }

    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    public ConsumerRecords<K, V> poll(long timeout) {
        return this.delegate.poll(timeout);
    }

    public ConsumerRecords<K, V> poll(Duration duration) {
        return this.delegate.poll(duration);
    }

    public void commitSync() {
        this.delegate.commitSync();
    }

    public void commitSync(Duration duration) {
        this.delegate.commitSync(duration);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.delegate.commitSync(offsets);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> map, Duration duration) {
        this.delegate.commitSync(map, duration);
    }

    public void commitAsync() {
        this.delegate.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback callback) {
        this.delegate.commitAsync(callback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.delegate.commitAsync(offsets, callback);
    }

    public void seek(TopicPartition partition, long offset) {
        this.delegate.seek(partition, offset);
    }

    public void seek(TopicPartition partition, OffsetAndMetadata offsetAndMetadata) {
        this.delegate.seek(partition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.delegate.seekToBeginning(partitions);
    }

    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.delegate.seekToEnd(partitions);
    }

    public long position(TopicPartition partition) {
        return this.delegate.position(partition);
    }

    public long position(TopicPartition topicPartition, Duration duration) {
        return this.delegate.position(topicPartition, duration);
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return this.delegate.committed(partition);
    }

    public OffsetAndMetadata committed(TopicPartition topicPartition, Duration duration) {
        return this.delegate.committed(topicPartition, duration);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    public List<PartitionInfo> partitionsFor(String s, Duration duration) {
        return this.delegate.partitionsFor(s, duration);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.delegate.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration duration) {
        return this.delegate.listTopics(duration);
    }

    public Set<TopicPartition> paused() {
        return this.delegate.paused();
    }

    public void pause(Collection<TopicPartition> partitions) {
        this.delegate.pause(partitions);
    }

    public void resume(Collection<TopicPartition> partitions) {
        this.delegate.resume(partitions);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        return this.delegate.offsetsForTimes(timestampsToSearch);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> map, Duration duration) {
        return this.delegate.offsetsForTimes(map, duration);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.beginningOffsets(partitions);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.delegate.beginningOffsets(collection, duration);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        return this.delegate.endOffsets(partitions);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.delegate.endOffsets(collection, duration);
    }

    public void close() {
        this.delegate.close();
    }

    public void close(long duration, TimeUnit unit) {
        this.delegate.close(duration, unit);
    }

    public void close(Duration duration) {
        this.delegate.close(duration);
    }

    public void wakeup() {
        this.delegate.wakeup();
    }
}

