/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import io.confluent.license.LicenseChanged;
import io.confluent.license.LicenseManager;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.streams.StreamsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseModule
implements Module {
    private static final Logger log = LoggerFactory.getLogger(LicenseModule.class);

    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    @Inject
    private LicenseHolder provide(ControlCenterConfig controlCenterConfig, StreamsConfig streamsConfig, ClusterManager clusterManager, @TopicStoreModule.CommandTopic TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic) throws Exception {
        String licenseStr = controlCenterConfig.getString("confluent.license");
        String clientId = TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.license.manager"), controlCenterConfig.getString("confluent.controlcenter.id"));
        String topicName = commandTopic.name;
        Map producerConfig = streamsConfig.getProducerConfigs(clientId);
        Map consumerConfig = streamsConfig.getGlobalConsumerConfigs(clientId);
        Map adminConfig = streamsConfig.getAdminConfigs(clientId);
        try {
            adminConfig.put("replication.factor", Integer.toString(controlCenterConfig.getInt("confluent.controlcenter.command.topic.replication")));
        }
        catch (Exception e) {
            log.info("Replication factor for command topic hasn't been configured. Using default value.");
        }
        LicenseManager licenseMgr = new LicenseManager(topicName, producerConfig, consumerConfig, adminConfig);
        Map<String, Map<String, Object>> clusters = clusterManager.getAllClusterConfigsWithClusterId();
        for (Map.Entry<String, Map<String, Object>> cluster : clusters.entrySet()) {
            String clusterId = cluster.getKey();
            log.info("Adding cluster to license manager : cluster id = " + clusterId);
            licenseMgr.addCluster(clientId, cluster.getValue());
        }
        License license = null;
        try {
            license = this.readLicenseFromPlainText(licenseStr, licenseMgr);
            log.info("License: " + license.toString());
        }
        catch (InvalidLicenseException e) {
            license = this.readLicenseFromFile(licenseStr, licenseMgr);
        }
        LicenseHolder handleLicenseChange = new LicenseHolder(license, licenseMgr);
        licenseMgr.addListener((Consumer)handleLicenseChange);
        licenseMgr.start();
        return handleLicenseChange;
    }

    private License readLicenseFromPlainText(String licenseStr, LicenseManager licenseMgr) throws InvalidLicenseException {
        License license = licenseMgr.registerOrValidateLicense(licenseStr);
        log.info("License: " + license.toString());
        return license;
    }

    private License readLicenseFromFile(String licensePathStr, LicenseManager licenseMgr) throws Exception {
        String licenseStr = "";
        try {
            Path licensePath = Paths.get(licensePathStr, new String[0]);
            if (licensePath.toFile().exists() && licensePath.toFile().isFile()) {
                log.info("attempting to read license from path={}", (Object)licensePath);
                licenseStr = Strings.nullToEmpty((String)Files.newBufferedReader(licensePath, Charset.defaultCharset()).readLine()).trim();
            } else {
                log.info("{} is neither a valid license string nor a valid license path. ", (Object)licensePathStr);
            }
        }
        catch (InvalidPathException ipe) {
            log.error("Catch InvalidPathException when parsing license file path.", (Throwable)ipe);
            throw ipe;
        }
        catch (IOException ioe) {
            log.error("Catch IOException when parsing license file path.", (Throwable)ioe);
            throw ioe;
        }
        catch (Exception exp) {
            log.error("Catch Exception when parsing license file path.", (Throwable)exp);
            throw exp;
        }
        try {
            License license = licenseMgr.registerOrValidateLicense(licenseStr);
            log.info("License: " + license.toString());
            return license;
        }
        catch (InvalidLicenseException ine) {
            log.error("license={} is invalid {}. please contact support@confluent.io for a valid license key", (Object)licenseStr, (Object)"InvalidLicenseException");
            throw ine;
        }
    }

    @Provides
    @Inject
    public License getLicense(LicenseHolder licenseHolder) {
        return licenseHolder.currentLicense;
    }

    @Provides
    @Inject
    public LicenseManager getLicenseManager(LicenseHolder licenseHolder) {
        return licenseHolder.licenseManager;
    }

    public static class LicenseHolder
    implements Consumer<LicenseChanged> {
        public License currentLicense;
        public LicenseManager licenseManager;

        public LicenseHolder(License currentLicense, LicenseManager licenseManager) {
            this.currentLicense = currentLicense;
            this.licenseManager = licenseManager;
        }

        @Override
        public void accept(LicenseChanged licenseChanged) {
            if (licenseChanged.type().equals((Object)LicenseChanged.Type.EXPIRED)) {
                log.error("License expired.");
            } else if (licenseChanged.type().equals((Object)LicenseChanged.Type.RENEWAL)) {
                log.info("The license has been renewed, meaning the new license is identical to the previous license except that the expiration date has been extended.");
            } else {
                log.info("The license has been updated with more changes than just the expiration date.");
            }
            this.currentLicense = licenseChanged.license();
            log.info("Updated current license to: audience = {}, expiration date = {}", (Object)this.currentLicense.audience(), (Object)this.currentLicense.expirationDateString());
        }
    }
}

