/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Preconditions;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.proxy.AsyncProxyServlet;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public abstract class AbstractProxyServlet
extends AsyncProxyServlet {
    private SslContextFactory sslContextFactory = new SslContextFactory();

    protected abstract String lookupEndpoint(String var1);

    @NotNull
    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = (SslContextFactory)Preconditions.checkNotNull((Object)sslContextFactory);
    }

    protected HttpClient newHttpClient() {
        int selectors = Math.max(1, ProcessorUtils.availableProcessors() / 2);
        String value = this.getServletConfig().getInitParameter("selectors");
        if (value != null) {
            selectors = Integer.parseInt(value);
        }
        return new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(selectors), this.sslContextFactory);
    }

    protected String rewriteTarget(HttpServletRequest clientRequest) {
        return this.extractProxyUri(clientRequest);
    }

    protected String extractProxyUri(HttpServletRequest clientRequest) {
        int start;
        String path = clientRequest.getPathInfo();
        if (path == null || !path.startsWith("/") || (start = path.indexOf("/", 1)) < 0) {
            return null;
        }
        String cluster = path.substring(1, start);
        String proxyPath = path.substring(start);
        String endpoint = this.lookupEndpoint(cluster);
        if (endpoint == null) {
            return null;
        }
        try {
            return new URIBuilder(endpoint).setPath(proxyPath).setQuery(clientRequest.getQueryString()).build().toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

