/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.command.CommandStore;
import io.confluent.command.CommandUtil;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.controlcenter.util.KvQuery;
import io.confluent.serializers.OrderedKeyUberSerde;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/2.0/alerts")
@Produces(value={"application/json"})
public class AlertsResource {
    private static final Logger log = LoggerFactory.getLogger(AlertsResource.class);
    static final Ordering<Alert.AlertInfo> ALERT_INFO_ORDERING = new Ordering<Alert.AlertInfo>(){

        public int compare(Alert.AlertInfo left, Alert.AlertInfo right) {
            return Ordering.natural().reverse().onResultOf((Function)new Function<Alert.AlertInfo, Long>(){

                public Long apply(Alert.AlertInfo input) {
                    return input.getTimestamp();
                }
            }).nullsLast().compare((Object)left, (Object)right);
        }
    };
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> monitoringTriggerConfigs;
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigs;
    private final CommandStore commandStore;
    private final Provider<ReadOnlyKeyValueStore<Bytes, Alert.AlertInfo>> alertHistoryStore;
    private final OrderedKeyUberSerde<Alert.AlertInfo> alertRangeSerde;
    private static final Map<CommandAlert.MonitoringTriggerConfig.ComponentCase, CommandAlert.MonitoringTriggerConfig.TriggerMetricCase> VALID_COMPONENT_TRIGGER = ImmutableMap.of((Object)CommandAlert.MonitoringTriggerConfig.ComponentCase.GROUP, (Object)CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.METRIC, (Object)CommandAlert.MonitoringTriggerConfig.ComponentCase.BROKERCLUSTERS, (Object)CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.BROKERMETRIC, (Object)CommandAlert.MonitoringTriggerConfig.ComponentCase.TOPIC, (Object)CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.TOPICMETRIC);

    @Inject
    public AlertsResource(CommandStore commandStore, @CommandModule.TriggerConfigs Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> monitoringTriggerConfigs, @CommandModule.ActionConfigs Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigs, @TopicStoreModule.AlertHistoryStore Provider<ReadOnlyKeyValueStore<Bytes, Alert.AlertInfo>> alertHistoryStore, @SerializationModule.TriggerEventsKeyPrefixSerde OrderedKeyUberSerde<Alert.AlertInfo> alertRangeSerde) {
        this.commandStore = commandStore;
        this.monitoringTriggerConfigs = monitoringTriggerConfigs;
        this.actionConfigs = actionConfigs;
        this.alertHistoryStore = alertHistoryStore;
        this.alertRangeSerde = alertRangeSerde;
    }

    @GET
    @Path(value="/triggers/{guid}")
    public CommandAlert.MonitoringTriggerConfig getTrigger(@PathParam(value="guid") String guid) {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)key);
        if (baseMessage == null) {
            throw new NotFoundException("unable to find config with guid=" + guid);
        }
        return AlertsResource.externalizeClusterId(baseMessage.getMonitoringTriggerConfig());
    }

    @GET
    @Path(value="/triggers")
    public List<CommandAlert.MonitoringTriggerConfig> getTriggers() {
        ArrayList out = Lists.newArrayList();
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).all();){
            while (i.hasNext()) {
                out.add(AlertsResource.externalizeClusterId(((Command.CommandMessage)((KeyValue)i.next()).value).getMonitoringTriggerConfig()));
            }
        }
        return out;
    }

    @POST
    @Path(value="/triggers")
    public CommandAlert.MonitoringTriggerConfig createTrigger(CommandAlert.MonitoringTriggerConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!Strings.isNullOrEmpty((String)config.getGuid())) {
            return this.updateTrigger(config.getGuid(), config);
        }
        AlertsResource.verifyMonitoringTriggerConfig(config);
        config = AlertsResource.internalizeClusterIdBuilder(config).setGuid(UUID.randomUUID().toString()).build();
        log.trace("config={}", (Object)config);
        this.commandStore.awaitCommand(CommandUtil.createCommandKey((String)config.getGuid(), (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG), Command.CommandMessage.newBuilder().setMonitoringTriggerConfig(config).build());
        return AlertsResource.externalizeClusterId(config);
    }

    @PUT
    @Path(value="/triggers/{guid}")
    public CommandAlert.MonitoringTriggerConfig updateTrigger(@PathParam(value="guid") String guid, CommandAlert.MonitoringTriggerConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!guid.equals(config.getGuid())) {
            throw new ClientErrorException("config guid does not match rest guid", Response.Status.CONFLICT);
        }
        AlertsResource.verifyMonitoringTriggerConfig(config);
        config = AlertsResource.internalizeClusterIdBuilder(config).build();
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)key);
        log.trace("config={}", (Object)config);
        log.trace("baseMessage={}", (Object)baseMessage);
        if (!baseMessage.hasMonitoringTriggerConfig()) {
            throw new ClientErrorException("guid is not associated with a trigger", Response.Status.BAD_REQUEST);
        }
        if (!guid.equals(baseMessage.getMonitoringTriggerConfig().getGuid())) {
            throw new ClientErrorException("supplied guid does not match stored guid", Response.Status.CONFLICT);
        }
        this.commandStore.awaitCommand(key, Command.CommandMessage.newBuilder((Command.CommandMessage)baseMessage).setMonitoringTriggerConfig(config).build());
        return AlertsResource.externalizeClusterId(config);
    }

    @DELETE
    @Path(value="/triggers/{guid}")
    public void deleteTrigger(@PathParam(value="guid") String guid) throws InterruptedException, ExecutionException, TimeoutException {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        log.info("deleting trigger={} and removing from associated actions", (Object)guid);
        this.commandStore.awaitCommand(key, null);
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)this.actionConfigs.get()).all();){
            while (i.hasNext()) {
                KeyValue keyValue = (KeyValue)i.next();
                if (!((Command.CommandMessage)keyValue.value).getActionConfig().getTriggerGuidList().contains((Object)guid)) continue;
                log.debug("removing trigger={} from action={}", (Object)guid, (Object)((Command.CommandKey)keyValue.key).getGuid());
                CommandAlert.ActionConfig.Builder acBuild = CommandAlert.ActionConfig.newBuilder((CommandAlert.ActionConfig)((Command.CommandMessage)keyValue.value).getActionConfig());
                acBuild.clearTriggerGuid();
                for (String triggerGuid : ((Command.CommandMessage)keyValue.value).getActionConfig().getTriggerGuidList()) {
                    if (triggerGuid.equals(guid)) continue;
                    acBuild.addTriggerGuid(triggerGuid);
                }
                this.commandStore.sendCommand((Command.CommandKey)keyValue.key, Command.CommandMessage.newBuilder((Command.CommandMessage)((Command.CommandMessage)keyValue.value)).setActionConfig(acBuild).build());
            }
        }
    }

    @POST
    @Path(value="/actions")
    public CommandAlert.ActionConfig createAction(CommandAlert.ActionConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!Strings.isNullOrEmpty((String)config.getGuid())) {
            return this.updateAction(config.getGuid(), config);
        }
        this.verifyActionConfig(config);
        config = CommandAlert.ActionConfig.newBuilder((CommandAlert.ActionConfig)config).setGuid(UUID.randomUUID().toString()).build();
        log.trace("config={}", (Object)config);
        this.commandStore.awaitCommand(CommandUtil.createCommandKey((String)config.getGuid(), (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG), Command.CommandMessage.newBuilder().setActionConfig(config).build());
        return config;
    }

    @GET
    @Path(value="/actions/{guid}")
    public CommandAlert.ActionConfig getAction(@PathParam(value="guid") String guid) {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.actionConfigs.get()).get((Object)key);
        if (baseMessage == null) {
            throw new NotFoundException("unable to find config with guid=" + guid);
        }
        return baseMessage.getActionConfig();
    }

    @GET
    @Path(value="/actions")
    public List<CommandAlert.ActionConfig> getActions() {
        ArrayList out = Lists.newArrayList();
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)this.actionConfigs.get()).all();){
            while (i.hasNext()) {
                out.add(((Command.CommandMessage)((KeyValue)i.next()).value).getActionConfig());
            }
        }
        return out;
    }

    @PUT
    @Path(value="/actions/{guid}")
    public CommandAlert.ActionConfig updateAction(@PathParam(value="guid") String guid, CommandAlert.ActionConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!guid.equals(config.getGuid())) {
            throw new ClientErrorException("config guid does not match rest guid", Response.Status.CONFLICT);
        }
        this.verifyActionConfig(config);
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.actionConfigs.get()).get((Object)key);
        log.trace("config={}", (Object)config);
        log.trace("baseMessage={}", (Object)baseMessage);
        this.commandStore.awaitCommand(key, Command.CommandMessage.newBuilder((Command.CommandMessage)baseMessage).setActionConfig(config).build());
        return config;
    }

    @DELETE
    @Path(value="/actions/{guid}")
    public void deleteAction(@PathParam(value="guid") String guid) throws InterruptedException, ExecutionException, TimeoutException {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        this.commandStore.awaitCommand(key, null);
    }

    @GET
    @Path(value="history")
    public List<Alert.AlertInfo> getHistory(@QueryParam(value="ts") Long timestamp, @QueryParam(value="guid") @DefaultValue(value="") String guid, @QueryParam(value="limit") @DefaultValue(value="50") Long limit) {
        if (limit > 500L) {
            throw new ClientErrorException("limit must be < 500", Response.Status.BAD_REQUEST);
        }
        ArrayList out = Lists.newArrayList();
        Bytes startKey = null;
        if (timestamp != null) {
            startKey = this.alertRangeSerde.key((Object)Alert.AlertInfo.newBuilder().setGuid(guid).setTimestamp(timestamp.longValue()).build());
        }
        try (KeyValueIterator iter = KvQuery.rangeFrom((ReadOnlyKeyValueStore)this.alertHistoryStore.get(), startKey);){
            while (iter.hasNext() && (long)out.size() < limit) {
                out.add(AlertsResource.externalizeClusterId((Alert.AlertInfo)((KeyValue)iter.next()).value));
            }
        }
        return ALERT_INFO_ORDERING.sortedCopy((Iterable)out);
    }

    private void verifyActionConfig(CommandAlert.ActionConfig config) {
        if (config.getIntervalMs() < 0L) {
            throw new ClientErrorException("intervalMs must be >=0", Response.Status.BAD_REQUEST);
        }
        for (String triggerGuid : config.getTriggerGuidList()) {
            Command.CommandMessage message = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)CommandUtil.createCommandKey((String)triggerGuid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG));
            if (message != null) continue;
            throw new ClientErrorException("invalid triggerGuid=" + triggerGuid, Response.Status.BAD_REQUEST);
        }
    }

    static void verifyMonitoringTriggerConfig(CommandAlert.MonitoringTriggerConfig config) {
        if (config.getLagMs() < 0L) {
            throw new ClientErrorException("lagMs must be >=0", Response.Status.BAD_REQUEST);
        }
        if (!VALID_COMPONENT_TRIGGER.containsKey(config.getComponentCase())) {
            throw new ClientErrorException("Must specify component", Response.Status.BAD_REQUEST);
        }
        if (VALID_COMPONENT_TRIGGER.get(config.getComponentCase()) != config.getTriggerMetricCase()) {
            throw new ClientErrorException("Invalid component/trigger pair: component=" + config.getComponentCase() + " trigger=" + config.getTriggerMetricCase(), Response.Status.BAD_REQUEST);
        }
        if (config.getBrokerMetric() == CommandAlert.BrokerTriggerMetricType.ZK_STATUS || config.getBrokerMetric() == CommandAlert.BrokerTriggerMetricType.CLUSTER_STATUS) {
            if (config.getValueCase() != CommandAlert.MonitoringTriggerConfig.ValueCase.STATUSVALUE) {
                throw new ClientErrorException("Must specify statusValue", Response.Status.BAD_REQUEST);
            }
        } else if (config.getValueCase() != CommandAlert.MonitoringTriggerConfig.ValueCase.LONGVALUE) {
            throw new ClientErrorException("Must specify longValue", Response.Status.BAD_REQUEST);
        }
    }

    private static CommandAlert.MonitoringTriggerConfig.Builder internalizeClusterIdBuilder(CommandAlert.MonitoringTriggerConfig config) {
        return CommandAlert.MonitoringTriggerConfig.newBuilder((CommandAlert.MonitoringTriggerConfig)config).setClusterId(ClusterMetadataDao.getInternalKafkaId(config.getClusterId()));
    }

    private static CommandAlert.MonitoringTriggerConfig externalizeClusterId(CommandAlert.MonitoringTriggerConfig config) {
        return CommandAlert.MonitoringTriggerConfig.newBuilder((CommandAlert.MonitoringTriggerConfig)config).setClusterId(ClusterMetadataDao.getExternalKafkaId(config.getClusterId())).build();
    }

    private static Alert.AlertInfo externalizeClusterId(Alert.AlertInfo alertInfo) {
        return Alert.AlertInfo.newBuilder((Alert.AlertInfo)alertInfo).setMonitoringTrigger(AlertsResource.externalizeClusterId(alertInfo.getMonitoringTrigger())).build();
    }
}

