/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.rest.res.ConsumerGroup;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/2.0/consumer/offsets/{clusterId}")
@Produces(value={"application/json"})
public class CachedConsumerOffsetsResource {
    private final Map<String, Map<String, ConsumerGroupOffsets>> offsets;

    @Inject
    public CachedConsumerOffsetsResource(@ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> offsets) {
        this.offsets = offsets;
    }

    @GET
    public List<ConsumerGroup> all(@PathParam(value="clusterId") String clusterId) {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.offsets.get(clusterId);
        if (cgOffsets == null) {
            throw new NotFoundException("unable to find clusterId=" + clusterId);
        }
        return Lists.newArrayList((Iterable)cgOffsets.values().stream().map(ConsumerGroup::new).collect(Collectors.toList()));
    }

    @GET
    @Path(value="/{consumerGroupId}")
    public ConsumerGroupOffsets consumerGroup(@PathParam(value="clusterId") String clusterId, @PathParam(value="consumerGroupId") String consumerGroupId) {
        Map<String, ConsumerGroupOffsets> cgOffsets = this.offsets.get(clusterId);
        if (cgOffsets == null) {
            throw new NotFoundException("unable to find clusterId=" + clusterId);
        }
        ConsumerGroupOffsets offsets = cgOffsets.get(consumerGroupId);
        if (offsets == null) {
            throw new NotFoundException("unable to find consumerGroupId=" + consumerGroupId);
        }
        return offsets;
    }
}

