/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDaoSupplier;
import io.confluent.controlcenter.data.KafkaDao;
import io.confluent.controlcenter.data.KafkaDaoSupplier;
import io.confluent.controlcenter.kafka.AdminClientSupplier;
import io.confluent.controlcenter.kafka.CachingConsumerSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConverter
implements ParamConverterProvider {
    private static final Logger log = LoggerFactory.getLogger(ClusterConverter.class);
    private final AdminClientSupplier<String> adminClientSupplier;
    private final CachingConsumerSupplier<byte[], byte[]> cachingConsumerSupplier;

    @Inject
    public ClusterConverter(AdminClientSupplier<String> adminClientSupplier, CachingConsumerSupplier<byte[], byte[]> cachingConsumerSupplier) {
        this.adminClientSupplier = adminClientSupplier;
        this.cachingConsumerSupplier = cachingConsumerSupplier;
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(KafkaDaoSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (KafkaDaoSupplier)() -> {
                        try {
                            return new KafkaDao(clusterId, ClusterConverter.this.adminClientSupplier.getClient(clusterId));
                        }
                        catch (IllegalArgumentException iae) {
                            throw new NotFoundException("unable to locate cluster " + clusterId);
                        }
                    };
                }

                public String toString(T kafkaDaoSupplier) {
                    return ((KafkaDao)((KafkaDaoSupplier)kafkaDaoSupplier).get()).clusterId();
                }
            };
        }
        if (rawType.isAssignableFrom(ConsumerOffsetsDaoSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (ConsumerOffsetsDaoSupplier)() -> {
                        try {
                            return new ConsumerOffsetsDao(clusterId, ClusterConverter.this.adminClientSupplier.getClient(clusterId), ClusterConverter.this.cachingConsumerSupplier.getConsumer(clusterId));
                        }
                        catch (IllegalArgumentException iae) {
                            throw new NotFoundException("unable to locate cluster " + clusterId);
                        }
                    };
                }

                public String toString(T consumerOffsetsDaoSupplier) {
                    return ((ConsumerOffsetsDao)((ConsumerOffsetsDaoSupplier)consumerOffsetsDaoSupplier).get()).clusterId();
                }
            };
        }
        return null;
    }
}

