/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.connect.ConnectClusterController;
import io.confluent.controlcenter.connect.ConnectClusterManager;
import io.confluent.controlcenter.connect.ConnectService;
import io.confluent.controlcenter.data.ConnectServiceSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public class ConnectClusterConverter
implements ParamConverterProvider {
    private final ConnectClusterManager connectClusterManager;

    @Inject
    public ConnectClusterConverter(ConnectClusterManager connectClusterManager) {
        this.connectClusterManager = connectClusterManager;
    }

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (rawType.isAssignableFrom(ConnectServiceSupplier.class)) {
            return new ParamConverter<T>(){

                public T fromString(String clusterId) {
                    return (ConnectServiceSupplier)() -> {
                        ConnectClusterController controller = ConnectClusterConverter.this.connectClusterManager.getController(clusterId);
                        if (controller == null) {
                            throw new NotFoundException("Unable to locate connect cluster " + clusterId);
                        }
                        return controller.getConnectService();
                    };
                }

                public String toString(T connectServiceSupplier) {
                    return ((ConnectService)((ConnectServiceSupplier)connectServiceSupplier).get()).getClusterId();
                }
            };
        }
        return null;
    }
}

